/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.jfa;

import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import de.jangassen.jfa.Selector;
import de.jangassen.jfa.annotation.Protocol;
import de.jangassen.jfa.appkit.NSObject;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import de.jangassen.jfa.foundation.VarArgs;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ObjcToJava
implements InvocationHandler {
    private static final String EQUALS = "equals";
    private static final String HASH_CODE = "hashCode";
    private static final String TO_STRING = "toString";
    private static final String DESCRIPTION = "description";
    private final ID id;

    public static <T extends NSObject> T alloc(Class<T> clazz) {
        return ObjcToJava.invokeStatic(clazz, "alloc");
    }

    public static <T extends NSObject> T invokeStatic(Class<T> clazz, String selector) {
        if (clazz.isAnnotationPresent(Protocol.class)) {
            throw new IllegalArgumentException("Cannot allocate protocols.");
        }
        ID instance = Foundation.invoke(Foundation.getObjcClass(clazz.getSimpleName()), selector, new Object[0]);
        return (T)((NSObject)ObjcToJava.map(instance, clazz));
    }

    public static <T> T map(ID result, Class<T> javaType) {
        if (NSObject.class.isAssignableFrom(javaType)) {
            return ObjcToJava.mapNSObject(result, javaType);
        }
        if (String.class.isAssignableFrom(javaType)) {
            return (T)Foundation.toStringViaUTF8(result);
        }
        if (Long.TYPE == javaType || Long.class == javaType) {
            return (T)Long.valueOf(result.longValue());
        }
        if (Integer.TYPE == javaType || Integer.class == javaType) {
            return (T)Integer.valueOf(result.intValue());
        }
        if (Double.TYPE == javaType || Double.class == javaType) {
            return (T)Double.valueOf(result.doubleValue());
        }
        if (Float.TYPE == javaType || Float.class == javaType) {
            return (T)Float.valueOf(result.floatValue());
        }
        if (Boolean.TYPE == javaType || Boolean.class == javaType) {
            return (T)Boolean.valueOf(result.booleanValue());
        }
        if (Byte.TYPE == javaType || Byte.class == javaType) {
            return (T)Byte.valueOf(result.byteValue());
        }
        if (Short.TYPE == javaType || Short.class == javaType) {
            return (T)Short.valueOf(result.shortValue());
        }
        if (ID.class.isAssignableFrom(javaType) || Object.class == javaType) {
            return (T)((Object)result);
        }
        if (Void.class == javaType || Void.TYPE == javaType) {
            return null;
        }
        if (Pointer.class == javaType) {
            return (T)new Pointer(result.longValue());
        }
        throw new IllegalArgumentException(javaType.getSimpleName() + " is not supported.");
    }

    private static <T> T mapNSObject(ID id, Class<T> clazz) {
        return clazz.cast(Proxy.newProxyInstance(ObjcToJava.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjcToJava(id)));
    }

    public static Optional<Class<?>> getJavaClass(ID id) {
        return ObjcToJava.getJavaClass(id, NSObject.class.getPackage());
    }

    public static Optional<Class<?>> getJavaClass(ID id, Package containingPackage) {
        if (id != null && !ID.NIL.equals((Object)id) && containingPackage != null) {
            try {
                Pointer classForCoderSelector = Foundation.createSelector("classForCoder");
                if (ObjcToJava.respondsToSelector(id, classForCoderSelector)) {
                    ID classNameId = Foundation.invoke(id, classForCoderSelector, new Object[0]);
                    String className = Foundation.stringFromClass(classNameId);
                    return Optional.of(Class.forName(containingPackage.getName() + "." + className));
                }
            }
            catch (ClassNotFoundException | RuntimeException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static boolean respondsToSelector(ID id, Pointer classNameSelector) {
        return Foundation.invoke(id, "respondsToSelector:", classNameSelector).booleanValue();
    }

    private ObjcToJava(ID id) {
        this.id = id;
    }

    private ID getId() {
        return this.id;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "equals": {
                return ObjcToJava.isFoundationProxy(args[0]) && Objects.equals((Object)this.getId(), (Object)ObjcToJava.getIdFromProxy(args[0]));
            }
            case "hashCode": {
                return this.id.hashCode();
            }
            case "toString": {
                return Foundation.toStringViaUTF8(Foundation.invoke(this.id, DESCRIPTION, new Object[0]));
            }
        }
        return this.invokeNative(method, args);
    }

    private Object invokeNative(Method method, Object[] args) {
        Object[] foundationArguments = this.getFoundationArguments(args);
        String selector = Selector.stringForMethod(method);
        ID result = Foundation.invoke(this.id, selector, foundationArguments);
        if (!this.isPrimitiveType(method.getReturnType()) && Foundation.isNil(result) || Void.TYPE == method.getReturnType()) {
            return null;
        }
        return this.wrapReturnValue(method, result);
    }

    private boolean isPrimitiveType(Class<?> returnType) {
        return Boolean.TYPE == returnType || Integer.TYPE == returnType || Long.TYPE == returnType || Double.TYPE == returnType || Float.TYPE == returnType;
    }

    private Object wrapReturnValue(Method method, ID result) {
        Class<?> returnType = this.getReturnType(method, result);
        return ObjcToJava.map(result, returnType);
    }

    private Class<?> getReturnType(Method method, ID result) {
        Optional<Class<?>> javaClass;
        Class<?> returnType = method.getReturnType();
        if (NSObject.class.isAssignableFrom(returnType) && (javaClass = ObjcToJava.getJavaClass(result)).isPresent()) {
            return javaClass.get();
        }
        return returnType;
    }

    private Object[] getFoundationArguments(Object[] args) {
        return args == null ? new Object[]{} : Arrays.stream(args).flatMap(this::flattenVarArgs).map(ObjcToJava::toFoundationArgument).toArray();
    }

    private Stream<Object> flattenVarArgs(Object value) {
        if (value instanceof VarArgs) {
            return Stream.concat(((VarArgs)value).getArgs().stream(), Stream.of(null));
        }
        return Stream.of(value);
    }

    public static Object toFoundationArgument(Object arg) {
        if (arg instanceof Structure || arg instanceof Foundation.CGFloat) {
            return arg;
        }
        return ObjcToJava.toID(arg);
    }

    public static ID toID(Object arg) {
        if (arg == null) {
            return ID.NIL;
        }
        if (ObjcToJava.isFoundationProxy(arg)) {
            return ObjcToJava.getIdFromProxy(arg);
        }
        if (arg instanceof String) {
            return Foundation.nsString((String)arg);
        }
        if (arg instanceof ID) {
            return (ID)((Object)arg);
        }
        if (arg instanceof Number) {
            return new ID(((Number)arg).longValue());
        }
        if (arg instanceof Pointer) {
            return new ID((Pointer)arg);
        }
        if (arg instanceof ByReference) {
            return new ID(((ByReference)arg).getPointer());
        }
        if (arg instanceof Method) {
            return new ID(Selector.forMethod((Method)arg));
        }
        if (arg instanceof NativeMapped) {
            return ObjcToJava.toID(((NativeMapped)arg).toNative());
        }
        if (arg instanceof Enum) {
            return Foundation.nsString(((Enum)arg).name());
        }
        throw new IllegalArgumentException(arg.getClass().getSimpleName() + " is not supported");
    }

    private static ID getIdFromProxy(Object arg) {
        return ((ObjcToJava)Proxy.getInvocationHandler(arg)).getId();
    }

    private static boolean isFoundationProxy(Object arg) {
        return Proxy.isProxyClass(arg.getClass()) && Proxy.getInvocationHandler(arg) instanceof ObjcToJava;
    }
}

