/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ha extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Lokacin Greenwhich a London",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "Tsayayyen Lokacin Apia",
               "",
               "Lokacin Rana na Apia",
               "",
               "Lokacin Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Tsayayyen Lokacin Cook Islands",
               "",
               "Rabin Lokacin Bazara na Cook Islands",
               "",
               "Lokacin Cook Islands",
               "",
            };
        final String[] Cuba = new String[] {
               "Tsayayyen Lokacin Kuba",
               "",
               "Lokacin Rana na Kuba",
               "",
               "Lokaci na Kuba",
               "",
            };
        final String[] Fiji = new String[] {
               "Tsayayyen Lokacin Fiji",
               "",
               "Lokacin Bazara na Fiji",
               "",
               "Lokacin Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Lokacin Golf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Tsayayyen Lokacin Hovd",
               "",
               "Lokacin Bazara na Hovd",
               "",
               "Lokacin Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Tsayayyen Lokacin Iran",
               "",
               "Lokacin Rana na Iran",
               "",
               "Lokacin Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Lokacin Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Tsayayyen Lokacin Omsk",
               "",
               "Lokacin Bazara na Omsk",
               "",
               "Lokacin Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Tsayayyen Lokacin Peru",
               "",
               "Lokacin Bazara na Peru",
               "",
               "Lokacin Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Lokacin Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Lokacin Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Tsayayyen Lokacin Chile",
               "",
               "Lokacin Bazara na Chile",
               "",
               "Lokacin Chile",
               "",
            };
        final String[] China = new String[] {
               "Tsayayyen Lokacin Sin",
               "",
               "Lokacin Rana na Sin",
               "",
               "Lokacin Sin",
               "",
            };
        final String[] Cocos = new String[] {
               "Lokacin Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Lokacin Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japan Standard Time",
               "",
               "Japan Daylight Time",
               "",
               "Lokacin Japan",
               "",
            };
        final String[] Korea = new String[] {
               "Tsayayyen Lokacin Koriya",
               "",
               "Lokacin Rana na Koriya",
               "",
               "Lokacin Koriya",
               "",
            };
        final String[] Nauru = new String[] {
               "Lokacin Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Lokacin Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Lokacin Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Tsayayyen Lokacin Samoa",
               "",
               "Lokacin Rana na Vote Samoa",
               "",
               "Lokacin Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "Lokacin Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tsayayyen Lokacin Tonga",
               "",
               "Lokacin Bazara na Tonga",
               "",
               "Lokacin Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Lokacin Yukon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Alaska = new String[] {
               "Tsayayyen Lokacin Alaska",
               "",
               "Lokacin Rana na Alaska",
               "",
               "Lokacin Alaska",
               "",
            };
        final String[] Amazon = new String[] {
               "Tsayayyen Lokacin Amazon",
               "",
               "Lokacin Bazara na Amazon",
               "",
               "Lokacin Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Lokacin Azores Daidaitacce",
               "",
               "Lokacin Azure na Bazara",
               "",
               "Lokacin Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Lokacin Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Tsayayyen Lokacin Easter Island",
               "",
               "Lokacin Bazara na Easter Island",
               "",
               "Lokacin Easter Island",
               "",
            };
        final String[] Guyana = new String[] {
               "Lokacin Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel Standard Time",
               "",
               "Israel Daylight Time",
               "",
               "Lokacin Isra\u02bcila",
               "",
            };
        final String[] Kosrae = new String[] {
               "Lokacin Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Lokacin Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Tsayayyen Lokacin Moscow",
               "",
               "Lokacin Bazara na Moscow",
               "",
               "Lokacin Moscow",
               "",
            };
        final String[] Ponape = new String[] {
               "Lokacin Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Lokacin Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tsayayyen Lokacin Taipei",
               "",
               "Lokacin Rana na Taipei",
               "",
               "Lokacin Taipei",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Lokacin Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Lokacin Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Lokacin Wallis da Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabian Standard Time",
               "",
               "Lokacin Rana na Arebiya",
               "",
               "Lokacin Arebiya",
               "",
            };
        final String[] Armenia = new String[] {
               "Tsayayyen Lokacin Armenia",
               "",
               "Lokacin Bazara na Armenia",
               "",
               "Lokacin Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Lokacin Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Tsayayyen Lokacin Chatham",
               "",
               "Lokacin Rana na Chatham",
               "",
               "Lokacin Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hadewa Lokaci na Duniya",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Lokacin Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Lokacin Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Tsayayyen Lokacin Georgia",
               "",
               "Georgia Summer Time",
               "",
               "Lokacin Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Tsayayyen Lokacin Irkutsk",
               "",
               "Lokacin Bazara na Irkutsk",
               "",
               "Lokacin Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Tsayayyen Lokacin Magadan",
               "",
               "Lokacin Bazara na Magadan",
               "",
               "Lokacin Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Lokacin Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Tsayayyen Lokacin Norfolk Island",
               "",
               "Lokacin Rana na Norfolk Island",
               "",
               "Lokacin Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Tsayayyen Lokacin Fernando de Noronha",
               "",
               "Lokacin Bazara na Fernando de Noronha",
               "",
               "Lokacin Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Lokacin R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Lokacin Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Lokacin Rana na Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Tsayayyen Lokacin Uruguay",
               "",
               "Lokacin Bazara na Uruguay",
               "",
               "Lokacin Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Tsayayyen Lokacin Vanuatu",
               "",
               "Lokacin Bazara na Vanuatu",
               "",
               "Lokacin Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Tsayayyen Lokacin Yakutsk",
               "",
               "Lokacin Bazara na Yakutsk",
               "",
               "Lokacin Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Tsayayyen Lokacin Kanada, Puerto Rico da Virgin Islands",
               "",
               "Lokacin Rana na Kanada, Puerto Rico da Virgin Islands",
               "",
               "Lokacin Kanada, Puerto Rico da Virgin Islands",
               "",
            };
        final String[] Brasilia = new String[] {
               "Tsayayyen Lokacin Brasillia",
               "",
               "Lokacin Bazara na Brasillia",
               "",
               "Lokacin Brasillia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Tsayayyen Lokacin Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Tsayayyen Lokacin Colombia",
               "",
               "Lokacin Bazara na Colombia",
               "",
               "Lokacin Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Tsayayyen Lokacin Falkland Islands",
               "",
               "Lokacin Bazara na Falkland Islands",
               "",
               "Lokacin Falkland Islands",
               "",
            };
        final String[] Malaysia = new String[] {
               "Lokacin Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Lokacin Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Tsayayyen Lokacin Ulaanbaatar",
               "",
               "Lokacin Bazara na Ulaanbaatar",
               "",
               "Lokacin Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Tsayayyen Lokacin Pakistan",
               "",
               "Lokacin Bazara na Pakistan",
               "",
               "Lokacin Pakistan",
               "",
            };
        final String[] Paraguay = new String[] {
               "Tsayayyen Lokacin Paraguay",
               "",
               "Lokacin Bazara na Paraguay",
               "",
               "Lokacin Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Lokacin Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Tsayayyen Lokacin Sakhalin",
               "",
               "Lokacin Bazara na Sakhalin",
               "",
               "Lokacin Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Lokacin Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Tsayayyen Lokacin Argentina",
               "",
               "Lokacin Bazara na Argentina",
               "",
               "Lokacin Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Lokacin Christmas Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Lokacin Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Tsayayyen Lokacin Hong Kong",
               "",
               "Lokacin Bazara na Hong Kong",
               "",
               "Lokacin Hong Kong",
               "",
            };
        final String[] Indochina = new String[] {
               "Lokacin Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Lokacin Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Tsayayyen Lokacin Lord Howe",
               "",
               "Lokacin Rana na Vote Lord Howe",
               "",
               "Lokacin Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Lokacin Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Tsayayyen Lokacin Mauritius",
               "",
               "Lokacin Bazara na Mauritius",
               "",
               "Lokacin Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Tsayayyen Lokacin Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Lokacin Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Tsayayyen Lokacin Volgograd",
               "",
               "Lokacin Bazara na Volgograd",
               "",
               "Lokacin Volgograd",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Tsayayyen Lokacin Azerbaijan",
               "",
               "Lokacin Bazara na Azerbaijan",
               "",
               "Lokacin Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Tsayayyen Lokacin Bangladesh",
               "",
               "Lokacin Bazara na Bangladesh",
               "",
               "Lokacin Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standard Time",
               "",
               "Lokacin Bazara na Cape Verde",
               "",
               "Lokacin Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Lokacin East Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Lokacin Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Lokacin Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Tsayayyen Lokacin Uzbekistan",
               "",
               "Lokacin Bazara na Uzbekistan",
               "",
               "Lokacin Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Lokacin Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Tsayayyen Lokacin Krasnoyarsk",
               "",
               "Lokacin Bazara na Krasnoyarsk",
               "",
               "Lokacin Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Tsayayyen Lokacin New Zealand",
               "",
               "Lokacin Rana na New Zealand",
               "",
               "Lokacin New Zealand",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standard Time",
               "",
               "Lokacin Bazara na Novosibirsk",
               "",
               "Lokacin Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Tsayayyen Lokacin Philippine",
               "",
               "Lokacin Bazara na Philippine",
               "",
               "Lokacin Philippine",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Tsayayyen Lokacin Vladivostok",
               "",
               "Lokacin Bazara na Vladivostok",
               "",
               "Lokacin Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Lokacin Tekun Indiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lokacin Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Lokaci Tsayayye ta Newfoundland",
               "",
               "Lokaci rana ta Newfoundland",
               "",
               "Lokacin Newfoundland",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Tsayayyen Lokacin Turkmenistan",
               "",
               "Turkmenistan Summer Time",
               "",
               "Lokacin Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Lokacin French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Tsayayyen Lokacin New Caledonia",
               "",
               "Lokacin Bazara na New Caledonia",
               "",
               "Lokacin New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Lokacin Kudancin Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Tsayayyen Lokacin Yekaterinburg",
               "",
               "Lokacin Bazara na Yekaterinburg",
               "",
               "Lokacin Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Lokacin Afirka ta Tsakiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Lokacin Gabashin Afirka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Tsayayyen Lokacin Afirka ta Yamma",
               "",
               "Lokacin Bazara na Afirka ta Yamma",
               "",
               "Lokacin Afirka ta Yamma",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Lokacin Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ida Tsakiyar a Lokaci Turai",
               "",
               "Tsakiyar bazara a lokaci turai",
               "",
               "Tsakiyar a lokaci turai",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Ida lokaci a turai gabas",
               "",
               "Gabas a lokaci turai da bazara",
               "",
               "Lokaci a turai gabas",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Ida lokaci ta yammacin turai",
               "",
               "Ida lokaci ta yammacin turai da bazara",
               "",
               "Lokaci ta yammacin turai",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Tsayayyen Lokacin Mekziko Pacific",
               "",
               "Lokacin Rana na Mekziko Pacific",
               "",
               "Lokacin Mekziko Pacific",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Tsayayyen Lokaci dake Arewacin Amurika ta Tsakiya",
               "",
               "Lokacin Rana dake Arewacin Amurika ta Tsakiya",
               "",
               "Lokaci dake Amurika arewa ta tsakiyar",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Tsayayyen Lokacin Gabas dake Arewacin Amurika",
               "",
               "Lokacin Rana ta Gabas dake Arewacin Amurika",
               "",
               "Lokacin Gabas dake Arewacin Amurikaa",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Lokaci Tsayayye na Arewacin Amurika",
               "",
               "Lokacin Rana na Arewacin Amurka",
               "",
               "Lokacin Arewacin Amurika",
               "",
            };
        final String[] French_Southern = new String[] {
               "Lokacin Kudancin Faransa da Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Lokacin Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Tsayayyen Lokacin Hawaii-Aleutian",
               "",
               "Lokacin Rana na Hawaii-Aleutian",
               "",
               "Lokaci na Hawaii-Aleutian",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Lokacin Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Tsayayyen Lokacin St. Pierre da Miquelon",
               "",
               "Lokacin Rana na St. Pierre da Miquelon",
               "",
               "Lokacin St. Pierre da Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Lokaci tsayayye na tsauni a Arewacin Amurica",
               "",
               "Lokacin Rana na Tsaunin Arewacin Amurka",
               "",
               "Lokacin Tsauni na Arewacin Amurka",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Lokacin Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Tsayayyen Lokacin Arewa Maso Yammacin Mekziko",
               "",
               "Lokacin Rana na Arewa Maso Yammacin Mekziko",
               "",
               "Lokacin Arewa Maso Yammacin Mekziko",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Lokacin Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Tsayayyen Lokacin Tsakiyar Austiraliya",
               "",
               "Lokacin Rana na Tsakiyar Austiraliya",
               "",
               "Central Australia Time",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern Standard Time",
               "",
               "Lokacin Rana na Gabashin Austiraliya",
               "",
               "Lokacin Gabashin Austiraliya",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Tsayayyen Lokacin Yammacin Austiralia",
               "",
               "Lokacin Rana na Yammacin Austiralia",
               "",
               "Lokacin Yammacin Austiralia",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Tsayayyen Lokacin Gabashin Greenland",
               "",
               "Lokacin Rana na Gabashin Greenland",
               "",
               "Lokacin Gabas na Greenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Tsayayyen Lokacin Yammacin Greenland",
               "",
               "Lokacin Rana na Yammacin Greenland",
               "",
               "Lokacin Yammacin Greenland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Lokacin Indonesia ta Tsakiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Lokacin Yammacin Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Lokacin Gabashin Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Lokacin Yammacin Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Tsayayyen Lokacin Yammacin Tsakiyar Austiraliya",
               "",
               "Lokacin Rana na Yammacin Tsakiyar Austiraliya",
               "",
               "Lokacin Yammacin Tsakiyar Austiraliya",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Lokacin Greenwhich a London",
                    "",
                    "Tsayayyen Lokacin Irish",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Lokacin Greenwhich a London",
                    "",
                    "Lokacin Bazara na Birtaniya",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Lokacin Greenwhich a London",
                    "",
                    "Lokacin Bazara na Birtaniya",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "timezone.excity.Etc/Unknown", "Birni da ba a sani ba" },
            { "timezone.excity.Asia/Baghdad", "Baghdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Arewacin Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Arewacin Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Arewacin Dakota" },
        };
        return data;
    }
}
