/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.parser.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.moquette.parser.netty.ConnAckEncoder;
import org.eclipse.moquette.parser.netty.ConnectEncoder;
import org.eclipse.moquette.parser.netty.DemuxEncoder;
import org.eclipse.moquette.parser.netty.DisconnectEncoder;
import org.eclipse.moquette.parser.netty.PingReqEncoder;
import org.eclipse.moquette.parser.netty.PingRespEncoder;
import org.eclipse.moquette.parser.netty.PubAckEncoder;
import org.eclipse.moquette.parser.netty.PubCompEncoder;
import org.eclipse.moquette.parser.netty.PubRecEncoder;
import org.eclipse.moquette.parser.netty.PubRelEncoder;
import org.eclipse.moquette.parser.netty.PublishEncoder;
import org.eclipse.moquette.parser.netty.SubAckEncoder;
import org.eclipse.moquette.parser.netty.SubscribeEncoder;
import org.eclipse.moquette.parser.netty.UnsubAckEncoder;
import org.eclipse.moquette.parser.netty.UnsubscribeEncoder;
import org.eclipse.moquette.proto.messages.AbstractMessage;

public class MQTTEncoder
extends MessageToByteEncoder<AbstractMessage> {
    private Map<Byte, DemuxEncoder> m_encoderMap = new HashMap<Byte, DemuxEncoder>();

    public MQTTEncoder() {
        this.m_encoderMap.put((byte)1, new ConnectEncoder());
        this.m_encoderMap.put((byte)2, new ConnAckEncoder());
        this.m_encoderMap.put((byte)3, new PublishEncoder());
        this.m_encoderMap.put((byte)4, new PubAckEncoder());
        this.m_encoderMap.put((byte)8, new SubscribeEncoder());
        this.m_encoderMap.put((byte)9, new SubAckEncoder());
        this.m_encoderMap.put((byte)10, new UnsubscribeEncoder());
        this.m_encoderMap.put((byte)14, new DisconnectEncoder());
        this.m_encoderMap.put((byte)12, new PingReqEncoder());
        this.m_encoderMap.put((byte)13, new PingRespEncoder());
        this.m_encoderMap.put((byte)11, new UnsubAckEncoder());
        this.m_encoderMap.put((byte)7, new PubCompEncoder());
        this.m_encoderMap.put((byte)5, new PubRecEncoder());
        this.m_encoderMap.put((byte)6, new PubRelEncoder());
    }

    @Override
    protected void encode(ChannelHandlerContext chc, AbstractMessage msg, ByteBuf bb) throws Exception {
        DemuxEncoder encoder = this.m_encoderMap.get(msg.getMessageType());
        if (encoder == null) {
            throw new CorruptedFrameException("Can't find any suitable decoder for message type: " + msg.getMessageType());
        }
        encoder.encode(chc, msg, bb);
    }
}

