/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.parser.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.eclipse.moquette.parser.netty.DemuxEncoder;
import org.eclipse.moquette.parser.netty.Utils;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.proto.messages.SubAckMessage;

class SubAckEncoder
extends DemuxEncoder<SubAckMessage> {
    SubAckEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext chc, SubAckMessage message, ByteBuf out) {
        if (message.types().isEmpty()) {
            throw new IllegalArgumentException("Found a suback message with empty topics");
        }
        int variableHeaderSize = 2 + message.types().size();
        ByteBuf buff = chc.alloc().buffer(6 + variableHeaderSize);
        try {
            buff.writeByte(144);
            buff.writeBytes(Utils.encodeRemainingLength(variableHeaderSize));
            buff.writeShort(message.getMessageID());
            for (AbstractMessage.QOSType c : message.types()) {
                int qosValue;
                qosValue = c == AbstractMessage.QOSType.FAILURE ? (qosValue = 128) : c.ordinal();
                buff.writeByte(qosValue);
            }
            out.writeBytes(buff);
        }
        finally {
            buff.release();
        }
    }
}

