/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.parser.netty;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeMap;
import java.util.List;
import org.eclipse.moquette.parser.netty.DemuxDecoder;
import org.eclipse.moquette.parser.netty.Utils;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.proto.messages.UnsubscribeMessage;

class UnsubscribeDecoder
extends DemuxDecoder {
    UnsubscribeDecoder() {
    }

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws Exception {
        in.resetReaderIndex();
        UnsubscribeMessage message = new UnsubscribeMessage();
        if (!this.decodeCommonHeader(message, 2, in)) {
            in.resetReaderIndex();
            return;
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new CorruptedFrameException("Found an Usubscribe message with qos other than LEAST_ONE, was: " + (Object)((Object)message.getQos()));
        }
        int start = in.readerIndex();
        message.setMessageID(in.readUnsignedShort());
        int readed = in.readerIndex() - start;
        while (readed < message.getRemainingLength()) {
            message.addTopicFilter(Utils.decodeString(in));
            readed = in.readerIndex() - start;
        }
        if (message.topicFilters().isEmpty()) {
            throw new CorruptedFrameException("unsubscribe MUST have got at least 1 topic");
        }
        out.add(message);
    }
}

