/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import org.eclipse.moquette.server.ConfigurationParser;
import org.eclipse.moquette.server.ServerAcceptor;
import org.eclipse.moquette.server.netty.NettyAcceptor;
import org.eclipse.moquette.spi.IMessaging;
import org.eclipse.moquette.spi.impl.SimpleMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private ServerAcceptor m_acceptor;
    SimpleMessaging messaging;
    Properties m_properties;

    public static void main(String[] args) throws IOException {
        final Server server = new Server();
        server.startServer();
        System.out.println("Server started, version 0.7");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                server.stopServer();
            }
        });
    }

    public void startServer() throws IOException {
        String configPath = System.getProperty("moquette.path", null);
        this.startServer(new File(configPath, "config/moquette.conf"));
    }

    public void startServer(File configFile) throws IOException {
        LOG.info("Using config file: " + configFile.getAbsolutePath());
        ConfigurationParser confParser = new ConfigurationParser();
        try {
            confParser.parse(configFile);
        }
        catch (ParseException pex) {
            LOG.warn("An error occurred in parsing configuration, fallback on default configuration", pex);
        }
        this.m_properties = confParser.getProperties();
        this.startServer(this.m_properties);
    }

    public void startServer(Properties configProps) throws IOException {
        ConfigurationParser confParser = new ConfigurationParser(configProps);
        this.m_properties = confParser.getProperties();
        LOG.info("Persistent store file: " + this.m_properties.get("persistent_store"));
        this.messaging = SimpleMessaging.getInstance();
        this.messaging.init(this.m_properties);
        this.m_acceptor = new NettyAcceptor();
        this.m_acceptor.initialize((IMessaging)this.messaging, this.m_properties);
    }

    public void stopServer() {
        LOG.info("Server stopping...");
        this.messaging.stop();
        this.m_acceptor.close();
        LOG.info("Server stopped");
    }

    public Properties getProperties() {
        return this.m_properties;
    }
}

