/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.moquette.parser.netty.MQTTDecoder;
import org.eclipse.moquette.parser.netty.MQTTEncoder;
import org.eclipse.moquette.server.ServerAcceptor;
import org.eclipse.moquette.server.netty.MoquetteIdleTimoutHandler;
import org.eclipse.moquette.server.netty.NettyMQTTHandler;
import org.eclipse.moquette.server.netty.metrics.BytesMetrics;
import org.eclipse.moquette.server.netty.metrics.BytesMetricsCollector;
import org.eclipse.moquette.server.netty.metrics.BytesMetricsHandler;
import org.eclipse.moquette.server.netty.metrics.MessageMetrics;
import org.eclipse.moquette.server.netty.metrics.MessageMetricsCollector;
import org.eclipse.moquette.server.netty.metrics.MessageMetricsHandler;
import org.eclipse.moquette.spi.IMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAcceptor
implements ServerAcceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NettyAcceptor.class);
    EventLoopGroup m_bossGroup;
    EventLoopGroup m_workerGroup;
    BytesMetricsCollector m_bytesMetricsCollector = new BytesMetricsCollector();
    MessageMetricsCollector m_metricsCollector = new MessageMetricsCollector();

    @Override
    public void initialize(IMessaging messaging, Properties props) throws IOException {
        this.m_bossGroup = new NioEventLoopGroup();
        this.m_workerGroup = new NioEventLoopGroup();
        this.initializePlainTCPTransport(messaging, props);
        this.initializeWebSocketTransport(messaging, props);
        String sslTcpPortProp = props.getProperty("ssl_port");
        String wssPortProp = props.getProperty("secure_websocket_port");
        if (sslTcpPortProp != null || wssPortProp != null) {
            SslHandler sslHandler = this.initSSLHandler(props);
            if (sslHandler == null) {
                LOG.error("Can't initialize SSLHandler layer! Exiting, check your configuration of jks");
                return;
            }
            this.initializeSSLTCPTransport(messaging, props, sslHandler);
            this.initializeWSSTransport(messaging, props, sslHandler);
        }
    }

    private void initFactory(String host, int port, final PipelineInitializer pipeliner) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.m_bossGroup, this.m_workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                try {
                    pipeliner.init(pipeline);
                }
                catch (Throwable th) {
                    LOG.error("Severe error during pipeline creation", th);
                    throw th;
                }
            }
        }).option(ChannelOption.SO_BACKLOG, 128)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.TCP_NODELAY, true)).childOption(ChannelOption.SO_KEEPALIVE, true);
        try {
            ChannelFuture f = b.bind(host, port);
            LOG.info("Server binded host: {}, port: {}", (Object)host, (Object)port);
            f.sync();
        }
        catch (InterruptedException ex) {
            LOG.error(null, ex);
        }
    }

    private void initializePlainTCPTransport(IMessaging messaging, Properties props) throws IOException {
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        int port = Integer.parseInt(props.getProperty("port"));
        this.initFactory(host, port, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) {
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeWebSocketTransport(IMessaging messaging, Properties props) throws IOException {
        String webSocketPortProp = props.getProperty("websocket_port");
        if (webSocketPortProp == null) {
            LOG.info("WebSocket is disabled");
            return;
        }
        int port = Integer.parseInt(webSocketPortProp);
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        this.initFactory(host, port, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) {
                pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler("/mqtt", "mqttv3.1, mqttv3.1.1"));
                pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
                pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeSSLTCPTransport(IMessaging messaging, Properties props, final SslHandler sslHandler) throws IOException {
        String sslPortProp = props.getProperty("ssl_port");
        if (sslPortProp == null) {
            LOG.info("SSL is disabled");
            return;
        }
        int sslPort = Integer.parseInt(sslPortProp);
        LOG.info("Starting SSL on port {}", (Object)sslPort);
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        this.initFactory(host, sslPort, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) throws Exception {
                pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeWSSTransport(IMessaging messaging, Properties props, final SslHandler sslHandler) throws IOException {
        String sslPortProp = props.getProperty("secure_websocket_port");
        if (sslPortProp == null) {
            LOG.info("SSL is disabled");
            return;
        }
        int sslPort = Integer.parseInt(sslPortProp);
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        this.initFactory(host, sslPort, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) throws Exception {
                pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler("/mqtt", "mqttv3.1, mqttv3.1.1"));
                pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
                pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    @Override
    public void close() {
        if (this.m_workerGroup == null) {
            throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
        }
        if (this.m_bossGroup == null) {
            throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
        }
        this.m_workerGroup.shutdownGracefully();
        this.m_bossGroup.shutdownGracefully();
        MessageMetrics metrics = this.m_metricsCollector.computeMetrics();
        LOG.info("Msg read: {}, msg wrote: {}", (Object)metrics.messagesRead(), (Object)metrics.messagesWrote());
        BytesMetrics bytesMetrics = this.m_bytesMetricsCollector.computeMetrics();
        LOG.info(String.format("Bytes read: %d, bytes wrote: %d", bytesMetrics.readBytes(), bytesMetrics.wroteBytes()));
    }

    private SslHandler initSSLHandler(Properties props) {
        String jksPath = props.getProperty("jks_path");
        LOG.info("Starting SSL using keystore at {}", (Object)jksPath);
        if (jksPath == null || jksPath.isEmpty()) {
            LOG.warn("You have configured the SSL port but not the jks_path, SSL not started");
            return null;
        }
        String keyStorePassword = props.getProperty("key_store_password");
        String keyManagerPassword = props.getProperty("key_manager_password");
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            LOG.warn("You have configured the SSL port but not the key_store_password, SSL not started");
            return null;
        }
        if (keyManagerPassword == null || keyManagerPassword.isEmpty()) {
            LOG.warn("You have configured the SSL port but not the key_manager_password, SSL not started");
            return null;
        }
        try {
            InputStream jksInputStream = this.jksDatastore(jksPath);
            SSLContext serverContext = SSLContext.getInstance("TLS");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(jksInputStream, keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyManagerPassword.toCharArray());
            serverContext.init(kmf.getKeyManagers(), null, null);
            SSLEngine engine = serverContext.createSSLEngine();
            engine.setUseClientMode(false);
            return new SslHandler(engine);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOG.error("Can't start SSL layer!", ex);
            return null;
        }
    }

    private InputStream jksDatastore(String jksPath) throws FileNotFoundException {
        URL jksUrl = this.getClass().getClassLoader().getResource(jksPath);
        if (jksUrl != null) {
            LOG.info("Starting with jks at {}, jks normal {}", (Object)jksUrl.toExternalForm(), (Object)jksUrl);
            return this.getClass().getClassLoader().getResourceAsStream(jksPath);
        }
        LOG.info("jks not found in bundled resources, try on the filesystem");
        File jksFile = new File(jksPath);
        if (jksFile.exists()) {
            LOG.info("Using {} ", (Object)jksFile.getAbsolutePath());
            return new FileInputStream(jksFile);
        }
        LOG.warn("File {} doesn't exists", (Object)jksFile.getAbsolutePath());
        return null;
    }

    abstract class PipelineInitializer {
        PipelineInitializer() {
        }

        abstract void init(ChannelPipeline var1) throws Exception;
    }

    static class ByteBufToWebSocketFrameEncoder
    extends MessageToMessageEncoder<ByteBuf> {
        ByteBufToWebSocketFrameEncoder() {
        }

        @Override
        protected void encode(ChannelHandlerContext chc, ByteBuf bb, List<Object> out) throws Exception {
            BinaryWebSocketFrame result = new BinaryWebSocketFrame();
            result.content().writeBytes(bb);
            out.add(result);
        }
    }

    static class WebSocketFrameToByteBufDecoder
    extends MessageToMessageDecoder<BinaryWebSocketFrame> {
        WebSocketFrameToByteBufDecoder() {
        }

        @Override
        protected void decode(ChannelHandlerContext chc, BinaryWebSocketFrame frame, List<Object> out) throws Exception {
            ByteBuf bb = frame.content();
            bb.retain();
            out.add(bb);
        }
    }
}

