/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.eclipse.moquette.server.ServerChannel;
import org.eclipse.moquette.server.netty.MoquetteIdleTimoutHandler;

public class NettyChannel
implements ServerChannel {
    private ChannelHandlerContext m_channel;
    public static final String ATTR_USERNAME = "username";
    public static final AttributeKey<Object> ATTR_KEY_KEEPALIVE = AttributeKey.valueOf("keepAlive");
    public static final AttributeKey<Object> ATTR_KEY_CLEANSESSION = AttributeKey.valueOf("cleanSession");
    public static final AttributeKey<Object> ATTR_KEY_CLIENTID = AttributeKey.valueOf("ClientID");
    public static final AttributeKey<Object> ATTR_KEY_USERNAME = AttributeKey.valueOf("username");

    NettyChannel(ChannelHandlerContext ctx) {
        this.m_channel = ctx;
    }

    @Override
    public Object getAttribute(AttributeKey<Object> key) {
        Attribute<Object> attr = this.m_channel.attr(key);
        return attr.get();
    }

    @Override
    public void setAttribute(AttributeKey<Object> key, Object value) {
        Attribute<Object> attr = this.m_channel.attr(key);
        attr.set(value);
    }

    @Override
    public void setIdleTime(int idleTime) {
        if (this.m_channel.pipeline().names().contains("idleStateHandler")) {
            this.m_channel.pipeline().remove("idleStateHandler");
        }
        if (this.m_channel.pipeline().names().contains("idleEventHandler")) {
            this.m_channel.pipeline().remove("idleEventHandler");
        }
        this.m_channel.pipeline().addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, idleTime));
        this.m_channel.pipeline().addAfter("idleStateHandler", "idleEventHandler", new MoquetteIdleTimoutHandler());
    }

    @Override
    public void close(boolean immediately) {
        this.m_channel.close();
    }

    @Override
    public void write(Object value) {
        this.m_channel.writeAndFlush(value);
    }

    public String toString() {
        String clientID = (String)this.getAttribute(ATTR_KEY_CLIENTID);
        return "session [clientID: " + clientID + "]" + super.toString();
    }
}

