/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.eclipse.moquette.proto.Utils;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.proto.messages.PingRespMessage;
import org.eclipse.moquette.server.netty.NettyChannel;
import org.eclipse.moquette.server.netty.NettyUtils;
import org.eclipse.moquette.spi.IMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyMQTTHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NettyMQTTHandler.class);
    private IMessaging m_messaging;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        AbstractMessage msg = (AbstractMessage)message;
        LOG.info("Received a message of type {}", (Object)Utils.msgType2String(msg.getMessageType()));
        try {
            switch (msg.getMessageType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 14: {
                    this.m_messaging.handleProtocolMessage(new NettyChannel(ctx), msg);
                    break;
                }
                case 12: {
                    PingRespMessage pingResp = new PingRespMessage();
                    ctx.writeAndFlush(pingResp);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Bad error in processing the message", ex);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = (String)NettyUtils.getAttribute(ctx, NettyChannel.ATTR_KEY_CLIENTID);
        this.m_messaging.lostConnection(clientID);
        ctx.close();
    }

    public void setMessaging(IMessaging messaging) {
        this.m_messaging = messaging;
    }
}

