/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.eclipse.moquette.server.netty.MoquetteIdleTimoutHandler;

public class NettyUtils {
    public static Object getAttribute(ChannelHandlerContext channel, AttributeKey<Object> key) {
        Attribute<Object> attr = channel.attr(key);
        return attr.get();
    }

    public static void setAttribute(ChannelHandlerContext channel, AttributeKey<Object> key, Object value) {
        Attribute<Object> attr = channel.attr(key);
        attr.set(value);
    }

    public static void setIdleTime(ChannelHandlerContext channel, int idleTime) {
        if (channel.pipeline().names().contains("idleStateHandler")) {
            channel.pipeline().remove("idleStateHandler");
        }
        if (channel.pipeline().names().contains("idleEventHandler")) {
            channel.pipeline().remove("idleEventHandler");
        }
        channel.pipeline().addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, idleTime));
        channel.pipeline().addAfter("idleStateHandler", "idleEventHandler", new MoquetteIdleTimoutHandler());
    }
}

