/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server.netty.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.moquette.server.netty.metrics.BytesMetrics;

public class BytesMetricsCollector {
    private AtomicLong readBytes = new AtomicLong();
    private AtomicLong wroteBytes = new AtomicLong();

    public BytesMetrics computeMetrics() {
        BytesMetrics allMetrics = new BytesMetrics();
        allMetrics.incrementRead(this.readBytes.get());
        allMetrics.incrementWrote(this.wroteBytes.get());
        return allMetrics;
    }

    public void sumReadBytes(long count) {
        this.readBytes.getAndAdd(count);
    }

    public void sumWroteBytes(long count) {
        this.wroteBytes.getAndAdd(count);
    }
}

