/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.spi.IMatchingCondition;
import org.eclipse.moquette.spi.impl.events.PublishEvent;

public interface IMessagesStore {
    public void initStore();

    public void storeRetained(String var1, ByteBuffer var2, AbstractMessage.QOSType var3);

    public Collection<StoredMessage> searchMatching(IMatchingCondition var1);

    public void storePublishForFuture(PublishEvent var1);

    public List<PublishEvent> listMessagesInSession(String var1);

    public void removeMessageInSession(String var1, Integer var2);

    public void dropMessagesInSession(String var1);

    public void cleanInFlight(String var1, int var2);

    public void addInFlight(PublishEvent var1, String var2, int var3);

    public int nextPacketID(String var1);

    public void close();

    public void persistQoS2Message(String var1, PublishEvent var2);

    public void removeQoS2Message(String var1);

    public PublishEvent retrieveQoS2Message(String var1);

    public void cleanRetained(String var1);

    public static class StoredMessage
    implements Serializable {
        final AbstractMessage.QOSType m_qos;
        final byte[] m_payload;
        final String m_topic;

        public StoredMessage(byte[] message, AbstractMessage.QOSType qos, String topic) {
            this.m_qos = qos;
            this.m_payload = message;
            this.m_topic = topic;
        }

        public AbstractMessage.QOSType getQos() {
            return this.m_qos;
        }

        public ByteBuffer getPayload() {
            return (ByteBuffer)ByteBuffer.allocate(this.m_payload.length).put(this.m_payload).flip();
        }

        public String getTopic() {
            return this.m_topic;
        }
    }
}

