/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.server.ServerChannel;
import org.eclipse.moquette.spi.impl.MQTTMessage;

class AnnotationSupport {
    private final Map<Class, Method> messageClassToMethod = new HashMap<Class, Method>();
    private Object targetInstance;

    AnnotationSupport() {
    }

    void processAnnotations(Object instance) {
        Method[] allMethods;
        this.targetInstance = instance;
        Class<?> instanceCls = instance.getClass();
        for (Method m : allMethods = instanceCls.getDeclaredMethods()) {
            MQTTMessage annotation = m.getAnnotation(MQTTMessage.class);
            if (annotation == null) continue;
            Class mqttMessageClass = annotation.message();
            this.messageClassToMethod.put(mqttMessageClass, m);
        }
    }

    void dispatch(ServerChannel session, AbstractMessage msg) {
        Method targetMethod = this.messageClassToMethod.get(msg.getClass());
        if (targetMethod == null) {
            throw new RuntimeException("Can't dispatch to any @MQTTMessage marked the message: " + msg);
        }
        try {
            targetMethod.invoke(this.targetInstance, session, msg);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

