/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.spi.IMatchingCondition;
import org.eclipse.moquette.spi.IMessagesStore;
import org.eclipse.moquette.spi.ISessionsStore;
import org.eclipse.moquette.spi.impl.Utils;
import org.eclipse.moquette.spi.impl.events.PublishEvent;
import org.eclipse.moquette.spi.impl.subscriptions.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStorageService
implements IMessagesStore,
ISessionsStore {
    private Map<String, Set<Subscription>> m_persistentSubscriptions = new HashMap<String, Set<Subscription>>();
    private Map<String, IMessagesStore.StoredMessage> m_retainedStore = new HashMap<String, IMessagesStore.StoredMessage>();
    private Map<String, List<PublishEvent>> m_persistentMessageStore = new HashMap<String, List<PublishEvent>>();
    private Map<String, PublishEvent> m_inflightStore = new HashMap<String, PublishEvent>();
    private Map<String, Set<Integer>> m_inflightIDs = new HashMap<String, Set<Integer>>();
    private Map<String, PublishEvent> m_qos2Store = new HashMap<String, PublishEvent>();
    private static final Logger LOG = LoggerFactory.getLogger(MemoryStorageService.class);

    @Override
    public void initStore() {
    }

    @Override
    public void cleanRetained(String topic) {
        this.m_retainedStore.remove(topic);
    }

    @Override
    public void storeRetained(String topic, ByteBuffer message, AbstractMessage.QOSType qos) {
        if (!message.hasRemaining()) {
            this.m_retainedStore.remove(topic);
        } else {
            byte[] raw = new byte[message.remaining()];
            message.get(raw);
            this.m_retainedStore.put(topic, new IMessagesStore.StoredMessage(raw, qos, topic));
        }
    }

    @Override
    public Collection<IMessagesStore.StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<IMessagesStore.StoredMessage> results = new ArrayList<IMessagesStore.StoredMessage>();
        for (Map.Entry<String, IMessagesStore.StoredMessage> entry : this.m_retainedStore.entrySet()) {
            IMessagesStore.StoredMessage storedMsg = entry.getValue();
            if (!condition.match(entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public void storePublishForFuture(PublishEvent evt) {
        LOG.debug("storePublishForFuture store evt {}", (Object)evt);
        String clientID = evt.getClientID();
        List storedEvents = Utils.defaultGet(this.m_persistentMessageStore, clientID, new ArrayList());
        storedEvents.add(evt);
        this.m_persistentMessageStore.put(clientID, storedEvents);
    }

    @Override
    public List<PublishEvent> listMessagesInSession(String clientID) {
        return new ArrayList<PublishEvent>(Utils.defaultGet(this.m_persistentMessageStore, clientID, Collections.emptyList()));
    }

    @Override
    public void removeMessageInSession(String clientID, Integer messageID) {
        List<PublishEvent> events = this.m_persistentMessageStore.get(clientID);
        PublishEvent toRemoveEvt = null;
        for (PublishEvent evt : events) {
            if (evt.getMessageID() == null && messageID == null) {
                toRemoveEvt = evt;
            }
            if (evt.getMessageID() != messageID) continue;
            toRemoveEvt = evt;
        }
        events.remove(toRemoveEvt);
        this.m_persistentMessageStore.put(clientID, events);
    }

    @Override
    public void dropMessagesInSession(String clientID) {
        this.m_persistentMessageStore.remove(clientID);
    }

    @Override
    public void cleanInFlight(String clientID, int packetID) {
        String publishKey = String.format("%s%d", clientID, packetID);
        this.m_inflightStore.remove(publishKey);
        Set<Integer> inFlightForClient = this.m_inflightIDs.get(clientID);
        if (inFlightForClient != null) {
            inFlightForClient.remove(packetID);
        }
    }

    @Override
    public void addInFlight(PublishEvent evt, String clientID, int packetID) {
        String publishKey = String.format("%s%d", clientID, packetID);
        this.m_inflightStore.put(publishKey, evt);
    }

    @Override
    public int nextPacketID(String clientID) {
        Set<Integer> inFlightForClient = this.m_inflightIDs.get(clientID);
        if (inFlightForClient == null) {
            int nextPacketId = 1;
            inFlightForClient = new HashSet<Integer>();
            inFlightForClient.add(nextPacketId);
            this.m_inflightIDs.put(clientID, inFlightForClient);
            return nextPacketId;
        }
        int maxId = Collections.max(inFlightForClient);
        int nextPacketId = (maxId + 1) % 65535;
        inFlightForClient.add(nextPacketId);
        return nextPacketId;
    }

    @Override
    public void removeSubscription(String topic, String clientID) {
        LOG.debug("removeSubscription topic filter: {} for clientID: {}", (Object)topic, (Object)clientID);
        if (!this.m_persistentSubscriptions.containsKey(clientID)) {
            return;
        }
        Set<Subscription> clientSubscriptions = this.m_persistentSubscriptions.get(clientID);
        Subscription toBeRemoved = null;
        for (Subscription sub : clientSubscriptions) {
            if (!sub.getTopicFilter().equals(topic)) continue;
            toBeRemoved = sub;
            break;
        }
        if (toBeRemoved != null) {
            clientSubscriptions.remove(toBeRemoved);
        }
    }

    @Override
    public void addNewSubscription(Subscription newSubscription) {
        Set<Subscription> subs;
        String clientID = newSubscription.getClientId();
        if (!this.m_persistentSubscriptions.containsKey(clientID)) {
            this.m_persistentSubscriptions.put(clientID, new HashSet());
        }
        if (!(subs = this.m_persistentSubscriptions.get(clientID)).contains(newSubscription)) {
            subs.add(newSubscription);
            this.m_persistentSubscriptions.put(clientID, subs);
        }
    }

    @Override
    public void wipeSubscriptions(String clientID) {
        this.m_persistentSubscriptions.remove(clientID);
    }

    @Override
    public void updateSubscriptions(String clientID, Set<Subscription> subscriptions) {
        this.m_persistentSubscriptions.put(clientID, subscriptions);
    }

    @Override
    public boolean contains(String clientID) {
        return this.m_persistentSubscriptions.containsKey(clientID);
    }

    @Override
    public List<Subscription> listAllSubscriptions() {
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        for (Map.Entry<String, Set<Subscription>> entry : this.m_persistentSubscriptions.entrySet()) {
            allSubscriptions.addAll((Collection<Subscription>)entry.getValue());
        }
        return allSubscriptions;
    }

    @Override
    public void close() {
    }

    @Override
    public void persistQoS2Message(String publishKey, PublishEvent evt) {
        LOG.debug("persistQoS2Message store pubKey {}, evt {}", (Object)publishKey, (Object)evt);
        this.m_qos2Store.put(publishKey, evt);
    }

    @Override
    public void removeQoS2Message(String publishKey) {
        this.m_qos2Store.remove(publishKey);
    }

    @Override
    public PublishEvent retrieveQoS2Message(String publishKey) {
        return this.m_qos2Store.get(publishKey);
    }
}

