/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl.events;

import java.nio.ByteBuffer;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.proto.messages.PublishMessage;
import org.eclipse.moquette.spi.impl.events.MessagingEvent;

public class PublishEvent
extends MessagingEvent {
    String m_topic;
    AbstractMessage.QOSType m_qos;
    ByteBuffer m_message;
    boolean m_retain;
    String m_clientID;
    Integer m_msgID;

    public PublishEvent(String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retain, String clientID, Integer msgID) {
        this.m_topic = topic;
        this.m_qos = qos;
        this.m_message = message;
        this.m_retain = retain;
        this.m_clientID = clientID;
        if (qos != AbstractMessage.QOSType.MOST_ONE) {
            this.m_msgID = msgID;
        }
    }

    public PublishEvent(String clientID, PublishMessage msg) {
        this.m_clientID = clientID;
        this.m_topic = msg.getTopicName();
        this.m_qos = msg.getQos();
        this.m_message = msg.getPayload();
        this.m_retain = msg.isRetainFlag();
        if (msg.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            this.m_msgID = msg.getMessageID();
        }
    }

    public String getTopic() {
        return this.m_topic;
    }

    public AbstractMessage.QOSType getQos() {
        return this.m_qos;
    }

    public ByteBuffer getMessage() {
        return this.m_message;
    }

    public boolean isRetain() {
        return this.m_retain;
    }

    public String getClientID() {
        return this.m_clientID;
    }

    public Integer getMessageID() {
        return this.m_msgID;
    }

    public String toString() {
        return "PublishEvent{m_msgID=" + this.m_msgID + ", m_clientID='" + this.m_clientID + '\'' + ", m_retain=" + this.m_retain + ", m_qos=" + (Object)((Object)this.m_qos) + ", m_topic='" + this.m_topic + '\'' + '}';
    }
}

