/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.moquette.spi.impl.security.IAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuthenticator
implements IAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(FileAuthenticator.class);
    private Map<String, String> m_identities = new HashMap<String, String>();
    private MessageDigest m_digest;

    public FileAuthenticator(String parent, String filePath) {
        File file = new File(parent, filePath);
        LOG.info("Loading password file: " + file);
        if (file.isDirectory()) {
            LOG.warn(String.format("Bad file reference %s is a directory", file));
            return;
        }
        try {
            this.m_digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.error("Can't find SHA-256 for password encoding", nsaex);
            throw new RuntimeException(nsaex);
        }
        try {
            FileReader reader = new FileReader(file);
            this.parse(reader);
        }
        catch (FileNotFoundException fex) {
            LOG.warn(String.format("Parsing not existing file %s", file), fex);
        }
        catch (ParseException pex) {
            LOG.warn(String.format("Format error in parsing password file %s", file), pex);
        }
    }

    private void parse(Reader reader) throws ParseException {
        if (reader == null) {
            return;
        }
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int commentMarker = line.indexOf(35);
                if (commentMarker != -1) {
                    if (commentMarker == 0) continue;
                    throw new ParseException(line, commentMarker);
                }
                if (line.isEmpty() || line.matches("^\\s*$")) continue;
                int delimiterIdx = line.indexOf(58);
                String username = line.substring(0, delimiterIdx).trim();
                String password = line.substring(delimiterIdx + 1).trim();
                this.m_identities.put(username, password);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
    }

    @Override
    public boolean checkValid(String username, String password) {
        String foundPwq = this.m_identities.get(username);
        if (foundPwq == null) {
            return false;
        }
        try {
            this.m_digest.update(password.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] digest = this.m_digest.digest();
        String encodedPasswd = new String(Hex.encodeHex(digest));
        return foundPwq.equals(encodedPasswd);
    }
}

