/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl.subscriptions;

import java.io.Serializable;
import org.eclipse.moquette.proto.messages.AbstractMessage;

public class Subscription
implements Serializable {
    AbstractMessage.QOSType requestedQos;
    String clientId;
    String topicFilter;
    boolean cleanSession;
    boolean active = true;

    public Subscription(String clientId, String topicFilter, AbstractMessage.QOSType requestedQos, boolean cleanSession) {
        this.requestedQos = requestedQos;
        this.clientId = clientId;
        this.topicFilter = topicFilter;
        this.cleanSession = cleanSession;
    }

    public static final Subscription createEmptySubscription(String clientId, boolean cleanSession) {
        return new Subscription(clientId, "", AbstractMessage.QOSType.MOST_ONE, cleanSession);
    }

    public String getClientId() {
        return this.clientId;
    }

    public AbstractMessage.QOSType getRequestedQos() {
        return this.requestedQos;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        if (this.cleanSession != that.cleanSession) {
            return false;
        }
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.requestedQos != that.requestedQos) {
            return false;
        }
        return !(this.topicFilter != null ? !this.topicFilter.equals(that.topicFilter) : that.topicFilter != null);
    }

    public int hashCode() {
        int result = this.requestedQos.hashCode();
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.topicFilter != null ? this.topicFilter.hashCode() : 0);
        result = 31 * result + (this.cleanSession ? 1 : 0);
        return result;
    }

    boolean match(String topic) {
        return this.topicFilter.equals(topic);
    }

    public String toString() {
        return String.format("[filter:%s, cliID: %s, qos: %s, active: %s]", new Object[]{this.topicFilter, this.clientId, this.requestedQos, this.active});
    }
}

