/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl.subscriptions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.moquette.spi.ISessionsStore;
import org.eclipse.moquette.spi.impl.subscriptions.Subscription;
import org.eclipse.moquette.spi.impl.subscriptions.Token;
import org.eclipse.moquette.spi.impl.subscriptions.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionsStore {
    private TreeNode subscriptions = new TreeNode(null);
    private ISessionsStore m_sessionsStore;
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionsStore.class);

    public static boolean validate(Subscription newSubscription) {
        try {
            SubscriptionsStore.parseTopic(newSubscription.topicFilter);
            return true;
        }
        catch (ParseException pex) {
            LOG.info("Bad matching topic filter <{}>", (Object)newSubscription.topicFilter);
            return false;
        }
    }

    public void init(ISessionsStore sessionsStore) {
        LOG.debug("init invoked");
        this.m_sessionsStore = sessionsStore;
        List<Subscription> subscriptions = sessionsStore.listAllSubscriptions();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reloading all stored subscriptions...subscription tree before {}", (Object)this.dumpTree());
        }
        for (Subscription subscription : subscriptions) {
            LOG.debug("Re-subscribing {} to topic {}", (Object)subscription.getClientId(), (Object)subscription.getTopicFilter());
            this.addDirect(subscription);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished loading. Subscription tree after {}", (Object)this.dumpTree());
        }
    }

    protected void addDirect(Subscription newSubscription) {
        TreeNode current = this.findMatchingNode(newSubscription.topicFilter);
        current.addSubscription(newSubscription);
    }

    private TreeNode findMatchingNode(String topic) {
        List<Object> tokens = new ArrayList();
        try {
            tokens = SubscriptionsStore.parseTopic(topic);
        }
        catch (ParseException ex) {
            LOG.error(null, ex);
        }
        TreeNode current = this.subscriptions;
        for (Token token : tokens) {
            TreeNode matchingChildren = current.childWithToken(token);
            if (matchingChildren != null) {
                current = matchingChildren;
                continue;
            }
            matchingChildren = new TreeNode(current);
            matchingChildren.setToken(token);
            current.addChild(matchingChildren);
            current = matchingChildren;
        }
        return current;
    }

    public void add(Subscription newSubscription) {
        this.addDirect(newSubscription);
    }

    public void removeSubscription(String topic, String clientID) {
        TreeNode matchNode = this.findMatchingNode(topic);
        Subscription toBeRemoved = null;
        for (Subscription sub : matchNode.subscriptions()) {
            if (!sub.topicFilter.equals(topic) || !sub.getClientId().equals(clientID)) continue;
            toBeRemoved = sub;
            break;
        }
        if (toBeRemoved != null) {
            matchNode.subscriptions().remove(toBeRemoved);
        }
    }

    public void clearAllSubscriptions() {
        SubscriptionTreeCollector subsCollector = new SubscriptionTreeCollector();
        this.bfsVisit(this.subscriptions, subsCollector, 0);
        Object allSubscriptions = subsCollector.getResult();
        Iterator i$ = allSubscriptions.iterator();
        while (i$.hasNext()) {
            Subscription subscription = (Subscription)i$.next();
            this.removeSubscription(subscription.getTopicFilter(), subscription.getClientId());
        }
    }

    public void removeForClient(String clientID) {
        this.subscriptions.removeClientSubscriptions(clientID);
        this.m_sessionsStore.wipeSubscriptions(clientID);
    }

    public void deactivate(String clientID) {
        this.subscriptions.deactivate(clientID);
        Set<Subscription> subs = this.subscriptions.findAllByClientID(clientID);
        this.m_sessionsStore.updateSubscriptions(clientID, subs);
    }

    public void activate(String clientID) {
        LOG.debug("Activating subscriptions for clientID <{}>", (Object)clientID);
        this.subscriptions.activate(clientID);
        Set<Subscription> subs = this.subscriptions.findAllByClientID(clientID);
        this.m_sessionsStore.updateSubscriptions(clientID, subs);
    }

    public List<Subscription> matches(String topic) {
        List<Token> tokens;
        try {
            tokens = SubscriptionsStore.parseTopic(topic);
        }
        catch (ParseException ex) {
            LOG.error(null, ex);
            return Collections.emptyList();
        }
        LinkedBlockingDeque<Token> tokenQueue = new LinkedBlockingDeque<Token>(tokens);
        ArrayList<Subscription> matchingSubs = new ArrayList<Subscription>();
        this.subscriptions.matches(tokenQueue, matchingSubs);
        HashMap<String, Subscription> subsForClient = new HashMap<String, Subscription>();
        for (Subscription sub : matchingSubs) {
            Subscription existingSub = (Subscription)subsForClient.get(sub.getClientId());
            if (existingSub != null && existingSub.getRequestedQos().ordinal() >= sub.getRequestedQos().ordinal()) continue;
            subsForClient.put(sub.getClientId(), sub);
        }
        return new ArrayList<Subscription>(subsForClient.values());
    }

    public boolean contains(Subscription sub) {
        return !this.matches(sub.topicFilter).isEmpty();
    }

    public int size() {
        return this.subscriptions.size();
    }

    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.bfsVisit(this.subscriptions, visitor, 0);
        return visitor.getResult();
    }

    private void bfsVisit(TreeNode node, IVisitor visitor, int deep) {
        if (node == null) {
            return;
        }
        visitor.visit(node, deep);
        for (TreeNode child : node.m_children) {
            this.bfsVisit(child, visitor, ++deep);
        }
    }

    public static boolean matchTopics(String msgTopic, String subscriptionTopic) {
        try {
            int i;
            List<Token> msgTokens = SubscriptionsStore.parseTopic(msgTopic);
            List<Token> subscriptionTokens = SubscriptionsStore.parseTopic(subscriptionTopic);
            Token subToken = null;
            for (i = 0; i < subscriptionTokens.size(); ++i) {
                subToken = subscriptionTokens.get(i);
                if (subToken != Token.MULTI && subToken != Token.SINGLE) {
                    if (i >= msgTokens.size()) {
                        return false;
                    }
                    Token msgToken = msgTokens.get(i);
                    if (msgToken.equals(subToken)) continue;
                    return false;
                }
                if (subToken == Token.MULTI) {
                    return true;
                }
                if (subToken != Token.SINGLE) continue;
            }
            return i == msgTokens.size();
        }
        catch (ParseException ex) {
            LOG.error(null, ex);
            throw new RuntimeException(ex);
        }
    }

    protected static List<Token> parseTopic(String topic) throws ParseException {
        ArrayList<Token> res = new ArrayList<Token>();
        String[] splitted = topic.split("/");
        if (splitted.length == 0) {
            res.add(Token.EMPTY);
        }
        if (topic.endsWith("/")) {
            String[] newSplitted = new String[splitted.length + 1];
            System.arraycopy(splitted, 0, newSplitted, 0, splitted.length);
            newSplitted[splitted.length] = "";
            splitted = newSplitted;
        }
        for (int i = 0; i < splitted.length; ++i) {
            String s = splitted[i];
            if (s.isEmpty()) {
                res.add(Token.EMPTY);
                continue;
            }
            if (s.equals("#")) {
                if (i != splitted.length - 1) {
                    throw new ParseException("Bad format of topic, the multi symbol (#) has to be the last one after a separator", i);
                }
                res.add(Token.MULTI);
                continue;
            }
            if (s.contains("#")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            if (s.equals("+")) {
                res.add(Token.SINGLE);
                continue;
            }
            if (s.contains("+")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            res.add(new Token(s));
        }
        return res;
    }

    private class SubscriptionTreeCollector
    implements IVisitor<List<Subscription>> {
        private List<Subscription> m_allSubscriptions = new ArrayList<Subscription>();

        private SubscriptionTreeCollector() {
        }

        @Override
        public void visit(TreeNode node, int deep) {
            this.m_allSubscriptions.addAll(node.subscriptions());
        }

        @Override
        public List<Subscription> getResult() {
            return this.m_allSubscriptions;
        }
    }

    private class DumpTreeVisitor
    implements IVisitor<String> {
        String s = "";

        private DumpTreeVisitor() {
        }

        @Override
        public void visit(TreeNode node, int deep) {
            String subScriptionsStr = "";
            String indentTabs = this.indentTabs(deep);
            for (Subscription sub : node.m_subscriptions) {
                subScriptionsStr = subScriptionsStr + indentTabs + sub.toString() + "\n";
            }
            this.s = this.s + (node.getToken() == null ? "" : node.getToken().toString());
            this.s = this.s + "\n" + (node.m_subscriptions.isEmpty() ? indentTabs : "") + subScriptionsStr;
        }

        private String indentTabs(int deep) {
            String s = "";
            for (int i = 0; i < deep; ++i) {
                s = s + "\t";
            }
            return s;
        }

        @Override
        public String getResult() {
            return this.s;
        }
    }

    public static interface IVisitor<T> {
        public void visit(TreeNode var1, int var2);

        public T getResult();
    }
}

