/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl.subscriptions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.moquette.spi.impl.subscriptions.Subscription;
import org.eclipse.moquette.spi.impl.subscriptions.Token;

class TreeNode {
    TreeNode m_parent;
    Token m_token;
    List<TreeNode> m_children = new ArrayList<TreeNode>();
    List<Subscription> m_subscriptions = new ArrayList<Subscription>();

    TreeNode(TreeNode parent) {
        this.m_parent = parent;
    }

    Token getToken() {
        return this.m_token;
    }

    void setToken(Token topic) {
        this.m_token = topic;
    }

    void addSubscription(Subscription s) {
        if (this.m_subscriptions.contains(s)) {
            return;
        }
        ClientIDComparator comparator = new ClientIDComparator();
        Collections.sort(this.m_subscriptions, comparator);
        int existingSubIdx = Collections.binarySearch(this.m_subscriptions, s, comparator);
        if (existingSubIdx >= 0) {
            this.m_subscriptions.remove(existingSubIdx);
        }
        this.m_subscriptions.add(s);
    }

    void addChild(TreeNode child) {
        this.m_children.add(child);
    }

    boolean isLeaf() {
        return this.m_children.isEmpty();
    }

    TreeNode childWithToken(Token token) {
        for (TreeNode child : this.m_children) {
            if (!child.getToken().equals(token)) continue;
            return child;
        }
        return null;
    }

    List<Subscription> subscriptions() {
        return this.m_subscriptions;
    }

    void matches(Queue<Token> tokens, List<Subscription> matchingSubs) {
        Token t = tokens.poll();
        if (t == null) {
            matchingSubs.addAll(this.m_subscriptions);
            for (TreeNode n : this.m_children) {
                if (n.getToken() != Token.MULTI && n.getToken() != Token.SINGLE) continue;
                matchingSubs.addAll(n.subscriptions());
            }
            return;
        }
        if (this.m_token == Token.MULTI) {
            matchingSubs.addAll(this.m_subscriptions);
            return;
        }
        for (TreeNode n : this.m_children) {
            if (!n.getToken().match(t)) continue;
            n.matches(new LinkedBlockingQueue<Token>(tokens), matchingSubs);
        }
    }

    int size() {
        int res = this.m_subscriptions.size();
        for (TreeNode child : this.m_children) {
            res += child.size();
        }
        return res;
    }

    void removeClientSubscriptions(String clientID) {
        ArrayList<Subscription> subsToRemove = new ArrayList<Subscription>();
        for (Subscription s : this.m_subscriptions) {
            if (!s.clientId.equals(clientID)) continue;
            subsToRemove.add(s);
        }
        for (Subscription s : subsToRemove) {
            this.m_subscriptions.remove(s);
        }
        for (TreeNode child : this.m_children) {
            child.removeClientSubscriptions(clientID);
        }
    }

    void deactivate(String clientID) {
        for (Subscription s : this.m_subscriptions) {
            if (!s.clientId.equals(clientID)) continue;
            s.setActive(false);
        }
        for (TreeNode child : this.m_children) {
            child.deactivate(clientID);
        }
    }

    public void activate(String clientID) {
        for (Subscription s : this.m_subscriptions) {
            if (!s.clientId.equals(clientID)) continue;
            s.setActive(true);
        }
        for (TreeNode child : this.m_children) {
            child.activate(clientID);
        }
    }

    Set<Subscription> findAllByClientID(String clientID) {
        HashSet<Subscription> subs = new HashSet<Subscription>();
        for (Subscription s : this.m_subscriptions) {
            if (!s.clientId.equals(clientID)) continue;
            subs.add(s);
        }
        for (TreeNode child : this.m_children) {
            subs.addAll(child.findAllByClientID(clientID));
        }
        return subs;
    }

    private class ClientIDComparator
    implements Comparator<Subscription> {
        private ClientIDComparator() {
        }

        @Override
        public int compare(Subscription o1, Subscription o2) {
            return o1.getClientId().compareTo(o2.getClientId());
        }
    }
}

