/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.moquette.proto.MQTTException;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.spi.IMatchingCondition;
import org.eclipse.moquette.spi.IMessagesStore;
import org.eclipse.moquette.spi.ISessionsStore;
import org.eclipse.moquette.spi.impl.Utils;
import org.eclipse.moquette.spi.impl.events.PublishEvent;
import org.eclipse.moquette.spi.impl.storage.StoredPublishEvent;
import org.eclipse.moquette.spi.impl.subscriptions.Subscription;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBPersistentStore
implements IMessagesStore,
ISessionsStore {
    private static final Logger LOG = LoggerFactory.getLogger(MapDBPersistentStore.class);
    private ConcurrentMap<String, IMessagesStore.StoredMessage> m_retainedStore;
    private ConcurrentMap<String, List<StoredPublishEvent>> m_persistentMessageStore;
    private ConcurrentMap<String, StoredPublishEvent> m_inflightStore;
    Map<String, Set<Integer>> m_inFlightIds;
    private ConcurrentMap<String, StoredPublishEvent> m_qos2Store;
    private ConcurrentMap<String, Set<Subscription>> m_persistentSubscriptions;
    private DB m_db;
    private String m_storePath;

    public MapDBPersistentStore() {
        this.m_storePath = "";
    }

    public MapDBPersistentStore(String storePath) {
        this.m_storePath = storePath;
    }

    @Override
    public void initStore() {
        if (this.m_storePath == null || this.m_storePath.isEmpty()) {
            this.m_db = DBMaker.newMemoryDB().make();
        } else {
            File tmpFile;
            try {
                tmpFile = new File(this.m_storePath);
                tmpFile.createNewFile();
            }
            catch (IOException ex) {
                LOG.error(null, ex);
                throw new MQTTException("Can't create temp file for subscriptions storage [" + this.m_storePath + "]", ex);
            }
            this.m_db = DBMaker.newFileDB(tmpFile).make();
        }
        this.m_retainedStore = this.m_db.getHashMap("retained");
        this.m_persistentMessageStore = this.m_db.getHashMap("persistedMessages");
        this.m_inflightStore = this.m_db.getHashMap("inflight");
        this.m_inFlightIds = this.m_db.getHashMap("inflightPacketIDs");
        this.m_persistentSubscriptions = this.m_db.getHashMap("subscriptions");
        this.m_qos2Store = this.m_db.getHashMap("qos2Store");
    }

    @Override
    public void cleanRetained(String topic) {
        this.m_retainedStore.remove(topic);
    }

    @Override
    public void storeRetained(String topic, ByteBuffer message, AbstractMessage.QOSType qos) {
        if (!message.hasRemaining()) {
            this.m_retainedStore.remove(topic);
        } else {
            byte[] raw = new byte[message.remaining()];
            message.get(raw);
            this.m_retainedStore.put(topic, new IMessagesStore.StoredMessage(raw, qos, topic));
        }
        this.m_db.commit();
    }

    @Override
    public Collection<IMessagesStore.StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<IMessagesStore.StoredMessage> results = new ArrayList<IMessagesStore.StoredMessage>();
        for (Map.Entry entry : this.m_retainedStore.entrySet()) {
            IMessagesStore.StoredMessage storedMsg = (IMessagesStore.StoredMessage)entry.getValue();
            if (!condition.match((String)entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public void storePublishForFuture(PublishEvent evt) {
        String clientID = evt.getClientID();
        List<StoredPublishEvent> storedEvents = !this.m_persistentMessageStore.containsKey(clientID) ? new ArrayList<StoredPublishEvent>() : (List)this.m_persistentMessageStore.get(clientID);
        storedEvents.add(this.convertToStored(evt));
        this.m_persistentMessageStore.put(clientID, storedEvents);
        this.m_db.commit();
        LOG.debug("Stored published message for client <{}> on topic <{}>", (Object)clientID, (Object)evt.getTopic());
    }

    @Override
    public List<PublishEvent> listMessagesInSession(String clientID) {
        ArrayList<PublishEvent> liveEvts = new ArrayList<PublishEvent>();
        List<StoredPublishEvent> storedEvts = Utils.defaultGet(this.m_persistentMessageStore, clientID, Collections.emptyList());
        for (StoredPublishEvent storedEvt : storedEvts) {
            liveEvts.add(this.convertFromStored(storedEvt));
        }
        return liveEvts;
    }

    @Override
    public void removeMessageInSession(String clientID, Integer messageID) {
        List events = (List)this.m_persistentMessageStore.get(clientID);
        if (events == null) {
            return;
        }
        StoredPublishEvent toRemoveEvt = null;
        for (StoredPublishEvent evt : events) {
            if (evt.getMessageID() == null && messageID == null) {
                toRemoveEvt = evt;
            }
            if (evt.getMessageID() != messageID) continue;
            toRemoveEvt = evt;
        }
        events.remove(toRemoveEvt);
        this.m_persistentMessageStore.put(clientID, events);
        this.m_db.commit();
    }

    @Override
    public void dropMessagesInSession(String clientID) {
        this.m_persistentMessageStore.remove(clientID);
        this.m_db.commit();
    }

    @Override
    public void cleanInFlight(String clientID, int packetID) {
        String publishKey = String.format("%s%d", clientID, packetID);
        this.m_inflightStore.remove(publishKey);
        Set<Integer> inFlightForClient = this.m_inFlightIds.get(clientID);
        if (inFlightForClient != null) {
            inFlightForClient.remove(packetID);
        }
        this.m_db.commit();
    }

    @Override
    public void addInFlight(PublishEvent evt, String clientID, int packetID) {
        String publishKey = String.format("%s%d", clientID, packetID);
        StoredPublishEvent storedEvt = this.convertToStored(evt);
        this.m_inflightStore.put(publishKey, storedEvt);
        this.m_db.commit();
    }

    @Override
    public int nextPacketID(String clientID) {
        Set<Integer> inFlightForClient = this.m_inFlightIds.get(clientID);
        if (inFlightForClient == null) {
            int nextPacketId = 1;
            inFlightForClient = new HashSet<Integer>();
            inFlightForClient.add(nextPacketId);
            this.m_inFlightIds.put(clientID, inFlightForClient);
            return nextPacketId;
        }
        int maxId = inFlightForClient.isEmpty() ? 0 : Collections.max(inFlightForClient);
        int nextPacketId = (maxId + 1) % 65535;
        inFlightForClient.add(nextPacketId);
        return nextPacketId;
    }

    @Override
    public void removeSubscription(String topic, String clientID) {
        LOG.debug("removeSubscription topic filter: {} for clientID: {}", (Object)topic, (Object)clientID);
        if (!this.m_persistentSubscriptions.containsKey(clientID)) {
            return;
        }
        Set clientSubscriptions = (Set)this.m_persistentSubscriptions.get(clientID);
        Subscription toBeRemoved = null;
        for (Subscription sub : clientSubscriptions) {
            if (!sub.getTopicFilter().equals(topic)) continue;
            toBeRemoved = sub;
            break;
        }
        if (toBeRemoved != null) {
            clientSubscriptions.remove(toBeRemoved);
        }
        this.m_persistentSubscriptions.put(clientID, clientSubscriptions);
        this.m_db.commit();
    }

    @Override
    public void addNewSubscription(Subscription newSubscription) {
        Set subs;
        LOG.debug("addNewSubscription invoked with subscription {}", (Object)newSubscription);
        String clientID = newSubscription.getClientId();
        if (!this.m_persistentSubscriptions.containsKey(clientID)) {
            LOG.debug("clientID {} is a newcome, creating it's subscriptions set", (Object)clientID);
            this.m_persistentSubscriptions.put(clientID, new HashSet());
        }
        if (!(subs = (Set)this.m_persistentSubscriptions.get(clientID)).contains(newSubscription)) {
            LOG.debug("updating clientID {} subscriptions set with new subscription", (Object)clientID);
            Subscription existingSubscription = null;
            for (Subscription scanSub : subs) {
                if (!newSubscription.getTopicFilter().equals(scanSub.getTopicFilter())) continue;
                existingSubscription = scanSub;
                break;
            }
            if (existingSubscription != null) {
                subs.remove(existingSubscription);
            }
            subs.add(newSubscription);
            this.m_persistentSubscriptions.put(clientID, subs);
            LOG.debug("clientID {} subscriptions set now is {}", (Object)clientID, (Object)subs);
        }
        this.m_db.commit();
    }

    @Override
    public void wipeSubscriptions(String clientID) {
        this.m_persistentSubscriptions.remove(clientID);
        this.m_db.commit();
    }

    @Override
    public void updateSubscriptions(String clientID, Set<Subscription> subscriptions) {
        this.m_persistentSubscriptions.put(clientID, subscriptions);
        this.m_db.commit();
    }

    @Override
    public List<Subscription> listAllSubscriptions() {
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        for (Map.Entry entry : this.m_persistentSubscriptions.entrySet()) {
            allSubscriptions.addAll((Collection)entry.getValue());
        }
        LOG.debug("retrieveAllSubscriptions returning subs {}", (Object)allSubscriptions);
        return allSubscriptions;
    }

    @Override
    public boolean contains(String clientID) {
        return this.m_persistentSubscriptions.containsKey(clientID);
    }

    @Override
    public void close() {
        this.m_db.commit();
        LOG.debug("persisted subscriptions {}", (Object)this.m_persistentSubscriptions);
        this.m_db.close();
        LOG.debug("closed disk storage");
    }

    @Override
    public void persistQoS2Message(String publishKey, PublishEvent evt) {
        LOG.debug("persistQoS2Message store pubKey: {}, evt: {}", (Object)publishKey, (Object)evt);
        this.m_qos2Store.put(publishKey, this.convertToStored(evt));
    }

    @Override
    public void removeQoS2Message(String publishKey) {
        LOG.debug("Removing stored Q0S2 message <{}>", (Object)publishKey);
        this.m_qos2Store.remove(publishKey);
    }

    @Override
    public PublishEvent retrieveQoS2Message(String publishKey) {
        StoredPublishEvent storedEvt = (StoredPublishEvent)this.m_qos2Store.get(publishKey);
        return this.convertFromStored(storedEvt);
    }

    private StoredPublishEvent convertToStored(PublishEvent evt) {
        StoredPublishEvent storedEvt = new StoredPublishEvent(evt);
        return storedEvt;
    }

    private PublishEvent convertFromStored(StoredPublishEvent evt) {
        byte[] message = evt.getMessage();
        ByteBuffer bbmessage = ByteBuffer.wrap(message);
        PublishEvent liveEvt = new PublishEvent(evt.getTopic(), evt.getQos(), bbmessage, evt.isRetain(), evt.getClientID(), evt.getMessageID());
        return liveEvt;
    }
}

