/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.moquette.commons.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationParser {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationParser.class);
    private Properties m_properties = new Properties();

    ConfigurationParser() {
        this.createDefaults();
    }

    ConfigurationParser(Properties properties) {
        this();
        for (Map.Entry<Object, Object> entrySet : properties.entrySet()) {
            this.m_properties.put(entrySet.getKey(), entrySet.getValue());
        }
    }

    private void createDefaults() {
        this.m_properties.put("port", Integer.toString(1883));
        this.m_properties.put("host", "0.0.0.0");
        this.m_properties.put("password_file", "");
        this.m_properties.put("persistent_store", Constants.DEFAULT_PERSISTENT_PATH);
        this.m_properties.put("allow_anonymous", (Object)true);
    }

    void parse(File file) throws ParseException {
        if (file == null) {
            LOG.warn("parsing NULL file, so fallback on default configuration!");
            return;
        }
        if (!file.exists()) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()));
            return;
        }
        try {
            FileReader reader = new FileReader(file);
            this.parse(reader);
        }
        catch (FileNotFoundException fex) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()), (Throwable)fex);
            return;
        }
    }

    void parse(Reader reader) throws ParseException {
        if (reader == null) {
            LOG.warn("parsing NULL reader, so fallback on default configuration!");
            return;
        }
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int commentMarker = line.indexOf(35);
                if (commentMarker != -1) {
                    if (commentMarker == 0) continue;
                    throw new ParseException(line, commentMarker);
                }
                if (line.isEmpty() || line.matches("^\\s*$")) continue;
                int deilimiterIdx = line.indexOf(32);
                String key = line.substring(0, deilimiterIdx).trim();
                String value = line.substring(deilimiterIdx).trim();
                this.m_properties.put(key, value);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
    }

    Properties getProperties() {
        return this.m_properties;
    }
}

