/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.proto.messages.ConnAckMessage;
import org.eclipse.moquette.proto.messages.ConnectMessage;
import org.eclipse.moquette.proto.messages.DisconnectMessage;
import org.eclipse.moquette.proto.messages.PubAckMessage;
import org.eclipse.moquette.proto.messages.PubCompMessage;
import org.eclipse.moquette.proto.messages.PubRecMessage;
import org.eclipse.moquette.proto.messages.PubRelMessage;
import org.eclipse.moquette.proto.messages.PublishMessage;
import org.eclipse.moquette.proto.messages.SubAckMessage;
import org.eclipse.moquette.proto.messages.SubscribeMessage;
import org.eclipse.moquette.proto.messages.UnsubAckMessage;
import org.eclipse.moquette.proto.messages.UnsubscribeMessage;
import org.eclipse.moquette.server.ConnectionDescriptor;
import org.eclipse.moquette.server.ServerChannel;
import org.eclipse.moquette.server.netty.NettyChannel;
import org.eclipse.moquette.spi.IMatchingCondition;
import org.eclipse.moquette.spi.IMessagesStore;
import org.eclipse.moquette.spi.ISessionsStore;
import org.eclipse.moquette.spi.impl.DebugUtils;
import org.eclipse.moquette.spi.impl.MQTTMessage;
import org.eclipse.moquette.spi.impl.ValueEvent;
import org.eclipse.moquette.spi.impl.events.LostConnectionEvent;
import org.eclipse.moquette.spi.impl.events.MessagingEvent;
import org.eclipse.moquette.spi.impl.events.OutputMessagingEvent;
import org.eclipse.moquette.spi.impl.events.PubAckEvent;
import org.eclipse.moquette.spi.impl.events.PublishEvent;
import org.eclipse.moquette.spi.impl.security.IAuthenticator;
import org.eclipse.moquette.spi.impl.security.IAuthorizator;
import org.eclipse.moquette.spi.impl.subscriptions.Subscription;
import org.eclipse.moquette.spi.impl.subscriptions.SubscriptionsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtocolProcessor
implements EventHandler<ValueEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolProcessor.class);
    private Map<String, ConnectionDescriptor> m_clientIDs = new HashMap<String, ConnectionDescriptor>();
    private SubscriptionsStore subscriptions;
    private boolean allowAnonymous;
    private IAuthorizator m_authorizator;
    private IMessagesStore m_messagesStore;
    private ISessionsStore m_sessionsStore;
    private IAuthenticator m_authenticator;
    private Map<String, WillMessage> m_willStore = new HashMap<String, WillMessage>();
    private ExecutorService m_executor;
    private RingBuffer<ValueEvent> m_ringBuffer;

    ProtocolProcessor() {
    }

    void init(SubscriptionsStore subscriptions, IMessagesStore storageService, ISessionsStore sessionsStore, IAuthenticator authenticator, boolean allowAnonymous, IAuthorizator authorizator) {
        this.subscriptions = subscriptions;
        this.allowAnonymous = allowAnonymous;
        this.m_authorizator = authorizator;
        LOG.debug("subscription tree on init {}", (Object)subscriptions.dumpTree());
        this.m_authenticator = authenticator;
        this.m_messagesStore = storageService;
        this.m_sessionsStore = sessionsStore;
        this.m_executor = Executors.newFixedThreadPool(1);
        Disruptor disruptor = new Disruptor(ValueEvent.EVENT_FACTORY, 32768, (Executor)this.m_executor);
        disruptor.handleEventsWith(new EventHandler[]{this});
        disruptor.start();
        this.m_ringBuffer = disruptor.getRingBuffer();
    }

    @MQTTMessage(message=ConnectMessage.class)
    void processConnect(ServerChannel session, ConnectMessage msg) {
        LOG.debug("CONNECT for client <{}>", (Object)msg.getClientID());
        if (msg.getProcotolVersion() != 3 && msg.getProcotolVersion() != 4) {
            ConnAckMessage badProto = new ConnAckMessage();
            badProto.setReturnCode((byte)1);
            LOG.warn("processConnect sent bad proto ConnAck");
            session.write((Object)badProto);
            session.close(false);
            return;
        }
        if (msg.getClientID() == null || msg.getClientID().length() == 0) {
            ConnAckMessage okResp = new ConnAckMessage();
            okResp.setReturnCode((byte)2);
            session.write((Object)okResp);
            return;
        }
        if (msg.isUserFlag()) {
            String pwd = null;
            if (msg.isPasswordFlag()) {
                pwd = msg.getPassword();
            } else if (!this.allowAnonymous) {
                this.failedCredentials(session);
                return;
            }
            if (!this.m_authenticator.checkValid(msg.getUsername(), pwd)) {
                this.failedCredentials(session);
                return;
            }
            session.setAttribute(NettyChannel.ATTR_KEY_USERNAME, (Object)msg.getUsername());
        } else if (!this.allowAnonymous) {
            this.failedCredentials(session);
            return;
        }
        if (this.m_clientIDs.containsKey(msg.getClientID())) {
            LOG.info("Found an existing connection with same client ID <{}>, forcing to close", (Object)msg.getClientID());
            ServerChannel oldSession = this.m_clientIDs.get(msg.getClientID()).getSession();
            boolean cleanSession = (Boolean)oldSession.getAttribute(NettyChannel.ATTR_KEY_CLEANSESSION);
            if (cleanSession) {
                this.cleanSession(msg.getClientID());
            }
            oldSession.close(false);
            LOG.debug("Existing connection with same client ID <{}>, forced to close", (Object)msg.getClientID());
        }
        ConnectionDescriptor connDescr = new ConnectionDescriptor(msg.getClientID(), session, msg.isCleanSession());
        this.m_clientIDs.put(msg.getClientID(), connDescr);
        int keepAlive = msg.getKeepAlive();
        LOG.debug("Connect with keepAlive {} s", (Object)keepAlive);
        session.setAttribute(NettyChannel.ATTR_KEY_KEEPALIVE, (Object)keepAlive);
        session.setAttribute(NettyChannel.ATTR_KEY_CLEANSESSION, (Object)msg.isCleanSession());
        session.setAttribute(NettyChannel.ATTR_KEY_CLIENTID, (Object)msg.getClientID());
        LOG.debug("Connect create session <{}>", (Object)session);
        session.setIdleTime(Math.round((float)keepAlive * 1.5f));
        if (msg.isWillFlag()) {
            AbstractMessage.QOSType willQos = AbstractMessage.QOSType.values()[msg.getWillQos()];
            byte[] willPayload = msg.getWillMessage();
            ByteBuffer bb = (ByteBuffer)ByteBuffer.allocate(willPayload.length).put(willPayload).flip();
            WillMessage will = new WillMessage(msg.getWillTopic(), bb, msg.isWillRetain(), willQos);
            this.m_willStore.put(msg.getClientID(), will);
        }
        this.subscriptions.activate(msg.getClientID());
        if (msg.isCleanSession()) {
            this.cleanSession(msg.getClientID());
        }
        ConnAckMessage okResp = new ConnAckMessage();
        okResp.setReturnCode((byte)0);
        if (!msg.isCleanSession() && this.m_sessionsStore.contains(msg.getClientID())) {
            okResp.setSessionPresent(true);
        }
        session.write((Object)okResp);
        LOG.info("Create persistent session for clientID <{}>", (Object)msg.getClientID());
        this.m_sessionsStore.addNewSubscription(Subscription.createEmptySubscription((String)msg.getClientID(), (boolean)true));
        LOG.info("Connected client ID <{}> with clean session {}", (Object)msg.getClientID(), (Object)msg.isCleanSession());
        if (!msg.isCleanSession()) {
            this.republishStoredInSession(msg.getClientID());
        }
    }

    private void failedCredentials(ServerChannel session) {
        ConnAckMessage okResp = new ConnAckMessage();
        okResp.setReturnCode((byte)4);
        session.write((Object)okResp);
        session.close(false);
    }

    private void republishStoredInSession(String clientID) {
        LOG.trace("republishStoredInSession for client <{}>", (Object)clientID);
        List publishedEvents = this.m_messagesStore.listMessagesInSession(clientID);
        if (publishedEvents.isEmpty()) {
            LOG.info("No stored messages for client <{}>", (Object)clientID);
            return;
        }
        LOG.info("republishing stored messages to client <{}>", (Object)clientID);
        for (PublishEvent pubEvt : publishedEvents) {
            this.sendPublish(pubEvt.getClientID(), pubEvt.getTopic(), pubEvt.getQos(), pubEvt.getMessage(), false, pubEvt.getMessageID());
            this.m_messagesStore.removeMessageInSession(clientID, pubEvt.getMessageID());
        }
    }

    @MQTTMessage(message=PubAckMessage.class)
    void processPubAck(ServerChannel session, PubAckMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        this.m_messagesStore.removeMessageInSession(clientID, Integer.valueOf(messageID));
    }

    private void cleanSession(String clientID) {
        LOG.info("cleaning old saved subscriptions for client <{}>", (Object)clientID);
        this.m_sessionsStore.wipeSubscriptions(clientID);
        this.subscriptions.removeForClient(clientID);
        this.m_messagesStore.dropMessagesInSession(clientID);
    }

    @MQTTMessage(message=PublishMessage.class)
    void processPublish(ServerChannel session, PublishMessage msg) {
        LOG.trace("PUB --PUBLISH--> SRV executePublish invoked with {}", (Object)msg);
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        String topic = msg.getTopicName();
        String user = (String)session.getAttribute(NettyChannel.ATTR_KEY_USERNAME);
        if (this.m_authorizator.canWrite(topic, user, clientID)) {
            this.executePublish(clientID, msg);
        } else {
            LOG.debug("topic {} doesn't have write credentials", (Object)topic);
        }
    }

    private void executePublish(String clientID, PublishMessage msg) {
        String topic = msg.getTopicName();
        AbstractMessage.QOSType qos = msg.getQos();
        ByteBuffer message = msg.getPayload();
        boolean retain = msg.isRetainFlag();
        Integer messageID = msg.getMessageID();
        LOG.info("PUBLISH from clientID <{}> on topic <{}> with QoS {}", new Object[]{clientID, topic, qos});
        PublishEvent publishEvt = new PublishEvent(clientID, msg);
        if (qos == AbstractMessage.QOSType.MOST_ONE) {
            this.forward2Subscribers(publishEvt);
        } else if (qos == AbstractMessage.QOSType.LEAST_ONE) {
            this.m_messagesStore.addInFlight(publishEvt, clientID, messageID.intValue());
            this.forward2Subscribers(publishEvt);
            this.m_messagesStore.cleanInFlight(clientID, messageID.intValue());
            this.sendPubAck(new PubAckEvent(messageID.intValue(), clientID));
            LOG.debug("replying with PubAck to MSG ID {}", (Object)messageID);
        } else if (qos == AbstractMessage.QOSType.EXACTLY_ONCE) {
            String publishKey = String.format("%s%d", clientID, messageID);
            this.m_messagesStore.persistQoS2Message(publishKey, publishEvt);
            this.sendPubRec(clientID, messageID);
        }
        if (retain) {
            if (qos == AbstractMessage.QOSType.MOST_ONE) {
                this.m_messagesStore.cleanRetained(topic);
            } else {
                this.m_messagesStore.storeRetained(topic, message, qos);
            }
        }
    }

    private void forwardPublishWill(WillMessage will, String clientID) {
        Integer messageId = null;
        if (will.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            messageId = this.m_messagesStore.nextPacketID(clientID);
        }
        PublishEvent pub = new PublishEvent(will.getTopic(), will.getQos(), will.getPayload(), will.isRetained(), clientID, messageId);
        this.forward2Subscribers(pub);
    }

    void forward2Subscribers(PublishEvent pubEvt) {
        String topic = pubEvt.getTopic();
        AbstractMessage.QOSType publishingQos = pubEvt.getQos();
        ByteBuffer origMessage = pubEvt.getMessage();
        boolean retain = pubEvt.isRetain();
        Integer messageID = pubEvt.getMessageID();
        LOG.debug("forward2Subscribers republishing to existing subscribers that matches the topic {}", (Object)topic);
        if (LOG.isDebugEnabled()) {
            LOG.debug("content <{}>", (Object)DebugUtils.payload2Str((ByteBuffer)origMessage));
            LOG.debug("subscription tree {}", (Object)this.subscriptions.dumpTree());
        }
        for (Subscription sub : this.subscriptions.matches(topic)) {
            AbstractMessage.QOSType qos = publishingQos;
            if (qos.ordinal() > sub.getRequestedQos().ordinal()) {
                qos = sub.getRequestedQos();
            }
            LOG.debug("Broker republishing to client <{}> topic <{}> qos <{}>, active {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos, sub.isActive()});
            ByteBuffer message = origMessage.duplicate();
            if (qos == AbstractMessage.QOSType.MOST_ONE && sub.isActive()) {
                this.sendPublish(sub.getClientId(), topic, qos, message, false, null);
                continue;
            }
            if (!sub.isCleanSession() && !sub.isActive()) {
                PublishEvent newPublishEvt = new PublishEvent(topic, qos, message, retain, sub.getClientId(), Integer.valueOf(messageID != null ? messageID : 0));
                this.m_messagesStore.storePublishForFuture(newPublishEvt);
                continue;
            }
            if (qos == AbstractMessage.QOSType.EXACTLY_ONCE) {
                PublishEvent newPublishEvt = new PublishEvent(topic, qos, message, retain, sub.getClientId(), Integer.valueOf(messageID != null ? messageID : 0));
                this.m_messagesStore.addInFlight(newPublishEvt, sub.getClientId(), messageID.intValue());
            }
            if (!sub.isActive()) continue;
            int messageId = this.m_messagesStore.nextPacketID(sub.getClientId());
            this.sendPublish(sub.getClientId(), topic, qos, message, false, messageId);
        }
    }

    protected void sendPublish(String clientId, String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retained, Integer messageID) {
        LOG.debug("sendPublish invoked clientId <{}> on topic <{}> QoS {} retained {} messageID {}", new Object[]{clientId, topic, qos, retained, messageID});
        PublishMessage pubMessage = new PublishMessage();
        pubMessage.setRetainFlag(retained);
        pubMessage.setTopicName(topic);
        pubMessage.setQos(qos);
        pubMessage.setPayload(message);
        LOG.info("send publish message to <{}> on topic <{}>", (Object)clientId, (Object)topic);
        if (LOG.isDebugEnabled()) {
            LOG.debug("content <{}>", (Object)DebugUtils.payload2Str((ByteBuffer)message));
        }
        if (pubMessage.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            pubMessage.setMessageID(messageID);
        } else if (messageID != null) {
            throw new RuntimeException("Internal bad error, trying to forwardPublish a QoS 0 message with PacketIdentifier: " + messageID);
        }
        if (this.m_clientIDs == null) {
            throw new RuntimeException("Internal bad error, found m_clientIDs to null while it should be initialized, somewhere it's overwritten!!");
        }
        LOG.debug("clientIDs are {}", this.m_clientIDs);
        if (this.m_clientIDs.get(clientId) == null) {
            throw new RuntimeException(String.format("Can't find a ConnectionDescriptor for client <%s> in cache <%s>", clientId, this.m_clientIDs));
        }
        ServerChannel session = this.m_clientIDs.get(clientId).getSession();
        LOG.debug("Session for clientId {} is {}", (Object)clientId, (Object)session);
        String user = (String)session.getAttribute(NettyChannel.ATTR_KEY_USERNAME);
        if (!this.m_authorizator.canRead(topic, user, clientId)) {
            LOG.debug("topic {} doesn't have read credentials", (Object)topic);
            return;
        }
        this.disruptorPublish(new OutputMessagingEvent(session, (AbstractMessage)pubMessage));
    }

    private void sendPubRec(String clientID, int messageID) {
        LOG.trace("PUB <--PUBREC-- SRV sendPubRec invoked for clientID {} with messageID {}", (Object)clientID, (Object)messageID);
        PubRecMessage pubRecMessage = new PubRecMessage();
        pubRecMessage.setMessageID(Integer.valueOf(messageID));
        this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientID).getSession(), (AbstractMessage)pubRecMessage));
    }

    private void sendPubAck(PubAckEvent evt) {
        LOG.trace("sendPubAck invoked");
        String clientId = evt.getClientID();
        PubAckMessage pubAckMessage = new PubAckMessage();
        pubAckMessage.setMessageID(Integer.valueOf(evt.getMessageId()));
        try {
            if (this.m_clientIDs == null) {
                throw new RuntimeException("Internal bad error, found m_clientIDs to null while it should be initialized, somewhere it's overwritten!!");
            }
            LOG.debug("clientIDs are {}", this.m_clientIDs);
            if (this.m_clientIDs.get(clientId) == null) {
                throw new RuntimeException(String.format("Can't find a ConnectionDescriptor for client %s in cache %s", clientId, this.m_clientIDs));
            }
            this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientId).getSession(), (AbstractMessage)pubAckMessage));
        }
        catch (Throwable t) {
            LOG.error(null, t);
        }
    }

    @MQTTMessage(message=PubRelMessage.class)
    void processPubRel(ServerChannel session, PubRelMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        LOG.debug("PUB --PUBREL--> SRV processPubRel invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        String publishKey = String.format("%s%d", clientID, messageID);
        PublishEvent evt = this.m_messagesStore.retrieveQoS2Message(publishKey);
        this.forward2Subscribers(evt);
        this.m_messagesStore.removeQoS2Message(publishKey);
        if (evt.isRetain()) {
            String topic = evt.getTopic();
            AbstractMessage.QOSType qos = evt.getQos();
            this.m_messagesStore.storeRetained(topic, evt.getMessage(), qos);
        }
        this.sendPubComp(clientID, messageID);
    }

    private void sendPubComp(String clientID, int messageID) {
        LOG.debug("PUB <--PUBCOMP-- SRV sendPubComp invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        PubCompMessage pubCompMessage = new PubCompMessage();
        pubCompMessage.setMessageID(Integer.valueOf(messageID));
        this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientID).getSession(), (AbstractMessage)pubCompMessage));
    }

    @MQTTMessage(message=PubRecMessage.class)
    void processPubRec(ServerChannel session, PubRecMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        LOG.debug("\t\tSRV <--PUBREC-- SUB processPubRec invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        PubRelMessage pubRelMessage = new PubRelMessage();
        pubRelMessage.setMessageID(Integer.valueOf(messageID));
        pubRelMessage.setQos(AbstractMessage.QOSType.LEAST_ONE);
        session.write((Object)pubRelMessage);
    }

    @MQTTMessage(message=PubCompMessage.class)
    void processPubComp(ServerChannel session, PubCompMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        LOG.debug("\t\tSRV <--PUBCOMP-- SUB processPubComp invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        this.m_messagesStore.cleanInFlight(clientID, messageID);
    }

    @MQTTMessage(message=DisconnectMessage.class)
    void processDisconnect(ServerChannel session, DisconnectMessage msg) throws InterruptedException {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        boolean cleanSession = (Boolean)session.getAttribute(NettyChannel.ATTR_KEY_CLEANSESSION);
        if (cleanSession) {
            this.cleanSession(clientID);
        }
        this.m_clientIDs.remove(clientID);
        session.close(true);
        this.subscriptions.deactivate(clientID);
        this.m_willStore.remove(clientID);
        LOG.info("DISCONNECT client <{}> with clean session {}", (Object)clientID, (Object)cleanSession);
    }

    void processConnectionLost(LostConnectionEvent evt) {
        String clientID = evt.clientID;
        if (this.m_clientIDs.remove(clientID) != null) {
            this.subscriptions.deactivate(clientID);
            LOG.info("Lost connection with client <{}>", (Object)clientID);
        }
        if (this.m_willStore.containsKey(clientID)) {
            WillMessage will = this.m_willStore.get(clientID);
            this.forwardPublishWill(will, clientID);
            this.m_willStore.remove(clientID);
        }
    }

    @MQTTMessage(message=UnsubscribeMessage.class)
    void processUnsubscribe(ServerChannel session, UnsubscribeMessage msg) {
        List topics = msg.topicFilters();
        int messageID = msg.getMessageID();
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        LOG.debug("UNSUBSCRIBE subscription on topics {} for clientID <{}>", (Object)topics, (Object)clientID);
        for (String topic : topics) {
            this.subscriptions.removeSubscription(topic, clientID);
            this.m_sessionsStore.removeSubscription(topic, clientID);
        }
        UnsubAckMessage ackMessage = new UnsubAckMessage();
        ackMessage.setMessageID(Integer.valueOf(messageID));
        LOG.info("replying with UnsubAck to MSG ID {}", (Object)messageID);
        session.write((Object)ackMessage);
    }

    @MQTTMessage(message=SubscribeMessage.class)
    void processSubscribe(ServerChannel session, SubscribeMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        boolean cleanSession = (Boolean)session.getAttribute(NettyChannel.ATTR_KEY_CLEANSESSION);
        LOG.debug("SUBSCRIBE client <{}> packetID {}", (Object)clientID, (Object)msg.getMessageID());
        SubAckMessage ackMessage = new SubAckMessage();
        ackMessage.setMessageID(msg.getMessageID());
        for (SubscribeMessage.Couple req : msg.subscriptions()) {
            AbstractMessage.QOSType qos = AbstractMessage.QOSType.values()[req.getQos()];
            Subscription newSubscription = new Subscription(clientID, req.getTopicFilter(), qos, cleanSession);
            boolean valid = this.subscribeSingleTopic(newSubscription, req.getTopicFilter());
            ackMessage.addType(valid ? qos : AbstractMessage.QOSType.FAILURE);
        }
        LOG.debug("SUBACK for packetID {}", (Object)msg.getMessageID());
        session.write((Object)ackMessage);
    }

    private boolean subscribeSingleTopic(Subscription newSubscription, final String topic) {
        LOG.info("<{}> subscribed to topic <{}> with QoS {}", new Object[]{newSubscription.getClientId(), topic, AbstractMessage.QOSType.formatQoS((AbstractMessage.QOSType)newSubscription.getRequestedQos())});
        boolean validTopic = SubscriptionsStore.validate((Subscription)newSubscription);
        if (!validTopic) {
            return false;
        }
        this.m_sessionsStore.addNewSubscription(newSubscription);
        this.subscriptions.add(newSubscription);
        Collection messages = this.m_messagesStore.searchMatching(new IMatchingCondition(){

            public boolean match(String key) {
                return SubscriptionsStore.matchTopics((String)key, (String)topic);
            }
        });
        for (IMessagesStore.StoredMessage storedMsg : messages) {
            LOG.debug("send publish message for topic {}", (Object)topic);
            Integer packetID = storedMsg.getQos() == AbstractMessage.QOSType.MOST_ONE ? null : Integer.valueOf(this.m_messagesStore.nextPacketID(newSubscription.getClientId()));
            this.sendPublish(newSubscription.getClientId(), storedMsg.getTopic(), storedMsg.getQos(), storedMsg.getPayload(), true, packetID);
        }
        return true;
    }

    private void disruptorPublish(OutputMessagingEvent msgEvent) {
        LOG.debug("disruptorPublish publishing event on output {}", (Object)msgEvent);
        long sequence = this.m_ringBuffer.next();
        ValueEvent event = (ValueEvent)this.m_ringBuffer.get(sequence);
        event.setEvent((MessagingEvent)msgEvent);
        this.m_ringBuffer.publish(sequence);
    }

    public void onEvent(ValueEvent t, long l, boolean bln) throws Exception {
        try {
            MessagingEvent evt = t.getEvent();
            OutputMessagingEvent outEvent = (OutputMessagingEvent)evt;
            LOG.debug("Output event, sending {}", (Object)outEvent.getMessage());
            outEvent.getChannel().write((Object)outEvent.getMessage());
        }
        finally {
            t.setEvent(null);
        }
    }

    static final class WillMessage {
        private final String topic;
        private final ByteBuffer payload;
        private final boolean retained;
        private final AbstractMessage.QOSType qos;

        public WillMessage(String topic, ByteBuffer payload, boolean retained, AbstractMessage.QOSType qos) {
            this.topic = topic;
            this.payload = payload;
            this.retained = retained;
            this.qos = qos;
        }

        public String getTopic() {
            return this.topic;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }

        public boolean isRetained() {
            return this.retained;
        }

        public AbstractMessage.QOSType getQos() {
            return this.qos;
        }
    }
}

