/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moquette.spi.impl;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.io.File;
import java.text.ParseException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.eclipse.moquette.proto.messages.AbstractMessage;
import org.eclipse.moquette.server.ServerChannel;
import org.eclipse.moquette.spi.IMessagesStore;
import org.eclipse.moquette.spi.IMessaging;
import org.eclipse.moquette.spi.ISessionsStore;
import org.eclipse.moquette.spi.impl.AnnotationSupport;
import org.eclipse.moquette.spi.impl.MemoryStorageService;
import org.eclipse.moquette.spi.impl.ProtocolProcessor;
import org.eclipse.moquette.spi.impl.ValueEvent;
import org.eclipse.moquette.spi.impl.events.LostConnectionEvent;
import org.eclipse.moquette.spi.impl.events.MessagingEvent;
import org.eclipse.moquette.spi.impl.events.ProtocolEvent;
import org.eclipse.moquette.spi.impl.events.StopEvent;
import org.eclipse.moquette.spi.impl.security.ACLFileParser;
import org.eclipse.moquette.spi.impl.security.AcceptAllAuthenticator;
import org.eclipse.moquette.spi.impl.security.DenyAllAuthorizator;
import org.eclipse.moquette.spi.impl.security.FileAuthenticator;
import org.eclipse.moquette.spi.impl.security.IAuthenticator;
import org.eclipse.moquette.spi.impl.security.IAuthorizator;
import org.eclipse.moquette.spi.impl.security.PermitAllAuthorizator;
import org.eclipse.moquette.spi.impl.subscriptions.SubscriptionsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessaging
implements IMessaging,
EventHandler<ValueEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessaging.class);
    private SubscriptionsStore subscriptions;
    private RingBuffer<ValueEvent> m_ringBuffer;
    private IMessagesStore m_storageService;
    private ISessionsStore m_sessionsStore;
    private ExecutorService m_executor;
    private Disruptor<ValueEvent> m_disruptor;
    private static SimpleMessaging INSTANCE;
    private final ProtocolProcessor m_processor = new ProtocolProcessor();
    private final AnnotationSupport annotationSupport = new AnnotationSupport();
    private boolean benchmarkEnabled = false;
    CountDownLatch m_stopLatch;
    Histogram histogram = new Histogram(5);

    private SimpleMessaging() {
    }

    public static SimpleMessaging getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimpleMessaging();
        }
        return INSTANCE;
    }

    public void init(Properties configProps) {
        this.subscriptions = new SubscriptionsStore();
        this.m_executor = Executors.newFixedThreadPool(1);
        this.m_disruptor = new Disruptor(ValueEvent.EVENT_FACTORY, 32768, (Executor)this.m_executor);
        this.m_disruptor.handleEventsWith(new EventHandler[]{this});
        this.m_disruptor.start();
        this.m_ringBuffer = this.m_disruptor.getRingBuffer();
        this.annotationSupport.processAnnotations((Object)this.m_processor);
        this.processInit(configProps);
    }

    private void disruptorPublish(MessagingEvent msgEvent) {
        LOG.debug("disruptorPublish publishing event {}", (Object)msgEvent);
        long sequence = this.m_ringBuffer.next();
        ValueEvent event = (ValueEvent)this.m_ringBuffer.get(sequence);
        event.setEvent(msgEvent);
        this.m_ringBuffer.publish(sequence);
    }

    public void lostConnection(String clientID) {
        this.disruptorPublish((MessagingEvent)new LostConnectionEvent(clientID));
    }

    public void handleProtocolMessage(ServerChannel session, AbstractMessage msg) {
        this.disruptorPublish((MessagingEvent)new ProtocolEvent(session, msg));
    }

    public void stop() {
        this.m_stopLatch = new CountDownLatch(1);
        this.disruptorPublish((MessagingEvent)new StopEvent());
        try {
            LOG.debug("waiting 10 sec to m_stopLatch");
            boolean elapsed = !this.m_stopLatch.await(10L, TimeUnit.SECONDS);
            LOG.debug("after m_stopLatch");
            this.m_executor.shutdown();
            this.m_disruptor.shutdown();
            if (elapsed) {
                LOG.error("Can't stop the server in 10 seconds");
            }
        }
        catch (InterruptedException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    public void onEvent(ValueEvent t, long l, boolean bln) throws Exception {
        MessagingEvent evt = t.getEvent();
        t.setEvent(null);
        LOG.info("onEvent processing messaging event from input ringbuffer {}", (Object)evt);
        if (evt instanceof StopEvent) {
            this.processStop();
            return;
        }
        if (evt instanceof LostConnectionEvent) {
            LostConnectionEvent lostEvt = (LostConnectionEvent)evt;
            this.m_processor.processConnectionLost(lostEvt);
            return;
        }
        if (evt instanceof ProtocolEvent) {
            ServerChannel session = ((ProtocolEvent)evt).getSession();
            AbstractMessage message = ((ProtocolEvent)evt).getMessage();
            try {
                long startTime = System.nanoTime();
                this.annotationSupport.dispatch(session, message);
                if (this.benchmarkEnabled) {
                    long delay = System.nanoTime() - startTime;
                    this.histogram.recordValue(delay);
                }
            }
            catch (Throwable th) {
                LOG.error("Serious error processing the message {} for {}", new Object[]{message, session, th});
            }
        }
    }

    private void processInit(Properties props) {
        PermitAllAuthorizator authorizator;
        this.benchmarkEnabled = Boolean.parseBoolean(System.getProperty("moquette.processor.benchmark", "false"));
        MemoryStorageService mapStorage = new MemoryStorageService();
        this.m_storageService = mapStorage;
        this.m_sessionsStore = mapStorage;
        this.m_storageService.initStore();
        this.subscriptions.init(this.m_sessionsStore);
        String passwdPath = props.getProperty("password_file", "");
        String configPath = System.getProperty("moquette.path", null);
        final String b4xUsername = props.getProperty("b4x_user", "");
        final String b4xPassword = props.getProperty("b4x_password", "");
        Object authenticator = b4xPassword.length() > 0 ? new IAuthenticator(){

            public boolean checkValid(String username, String password) {
                return b4xUsername.equals(username) && b4xPassword.equals(password);
            }
        } : (passwdPath.isEmpty() ? new AcceptAllAuthenticator() : new FileAuthenticator(configPath, passwdPath));
        String aclFilePath = props.getProperty("acl_file", "");
        if (aclFilePath != null && !aclFilePath.isEmpty()) {
            authorizator = new DenyAllAuthorizator();
            File aclFile = new File(configPath, aclFilePath);
            try {
                authorizator = ACLFileParser.parse((File)aclFile);
            }
            catch (ParseException pex) {
                LOG.error(String.format("Format error in parsing acl file %s", aclFile), (Throwable)pex);
            }
            LOG.info("Using acl file defined at path {}", (Object)aclFilePath);
        } else {
            authorizator = new PermitAllAuthorizator();
            LOG.info("Starting without ACL definition");
        }
        boolean allowAnonymous = Boolean.parseBoolean(props.getProperty("allow_anonymous", "true"));
        this.m_processor.init(this.subscriptions, this.m_storageService, this.m_sessionsStore, (IAuthenticator)authenticator, allowAnonymous, (IAuthorizator)authorizator);
    }

    private void processStop() {
        LOG.debug("processStop invoked");
        this.m_storageService.close();
        LOG.debug("subscription tree {}", (Object)this.subscriptions.dumpTree());
        this.subscriptions = null;
        this.m_stopLatch.countDown();
        if (this.benchmarkEnabled) {
            this.histogram.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
        }
    }
}

